package com.allcam.mss.ability.media.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class VideoSplitRequest extends BaseRequest
{
    private static final long serialVersionUID = 3982967858338470687L;

    /**
     * 文件编号，同一个文件不能重复创建分割任务
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String fileId;

    /**
     * 分割方式：
     * 1.	按照分割数量分割视频
     * 2.	按照单片时长分割视频
     */
    @Verification(type = VerifyType.BETWEEN, param = "1,2")
    private int splitMode;

    /**
     * 分割方式1：分割数量，必须为大于1的整数，同时需要保证分割后，每一段视频的时长不小于30s
     * 分割方式2：单片时长，单位（秒），大于等于30s
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String splitParam;

    /**
     * 如果是后台服务方式请求，可传入回调地址接收视频分割完成通知。
     */
    private String callbackUrl;
}
