package com.allcam.mss.ability.media.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class VideoCaptureRequest extends BaseRequest
{

    private static final long serialVersionUID = 5378599543594654845L;

    /**
     * 视频源地址
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String source;

    /**
     * 截取媒体类型
     * jpg: 截取图片
     * mp4: 截取视频
     * gif: 截取动图
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String mediaType;

    /**
     * 截取宽，可不设置
     */
    @Verification(type = VerifyType.BETWEEN, param = "0,")
    private int width;

    /**
     * 截取高，可不设置
     */
    @Verification(type = VerifyType.BETWEEN, param = "0,")
    private int height;

    /**
     * 截取帧率
     * mp4和gif有效，可不填
     */
    @Verification(type = VerifyType.BETWEEN, param = "0,")
    private int fps;

    /**
     * 裁剪的偏移量，单位秒
     * 偏移量不能超过总时长
     */
    @Verification(type = VerifyType.BETWEEN, param = "0,")
    private int offset;

    /**
     * 录制时长（单位：秒）最小5秒
     * mp4和gif必填
     */
    @Verification(type = VerifyType.BETWEEN, param = "5,")
    private int duration;
}
