package com.allcam.mss.ability.media.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.allcam.mss.ability.constant.UrlType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class StreamProxyRequest extends BaseRequest
{

    private static final long serialVersionUID = -8893579783080603627L;

    /**
     * 原视频地址
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String sourceUrl;

    /**
     * 播放类型：
     * 1.	RTMP
     * 2.	HLS
     */
    @Verification(type = VerifyType.NOT_ZERO)
    private int urlType = UrlType.RTMP.getType();

    /**
     * 代理状态回调通知地址,不传使用默认配置
     */
    private String callbackUrl;
}
