package com.allcam.mss.ability.media.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class LiveRecordStartRequest extends BaseRequest
{

    private static final long serialVersionUID = 8233939004394323797L;

    @Verification(type = VerifyType.HAS_TEXT)
    private String cameraId;

    @Verification(type = VerifyType.BETWEEN, param = "1,3")
    private int streamType = 1;

    @Verification(type = VerifyType.BETWEEN, param = "30,3600")
    private int duration;

}
