package com.allcam.mss.ability.media.model;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class RecordTaskSearchInfo extends AcBaseBean
{
    private static final long serialVersionUID = -1237457034155822439L;

    /**
     * 录像类型，默认所有
     * 0-	所有
     * 1-	实时视频录像
     * 2-	回放视频录像
     */
    private int type;

    @Verification(type = VerifyType.HAS_TEXT)
    private String beginTime;

    @Verification(type = VerifyType.HAS_TEXT)
    private String endTime;

    @JsonIgnore
    private String creatorId;
}
