package com.allcam.mss.ability.media;

import com.allcam.mss.ability.media.request.*;

/**
 * @author Beowulf
 */
public interface MediaRecordService
{
    /**
     * 开启直播视频录制
     *
     * @param request 请求
     * @return 响应
     */
    VideoRecordStartResponse startLiveRecord(LiveRecordStartRequest request);

    /**
     * 开启回放视频录制
     *
     * @param request 请求
     * @return 响应
     */
    VideoRecordStartResponse startPlaybackRecord(PlaybackRecordStartRequest request);

    /**
     * 获取单个手动录像任务详情
     *
     * @param request 请求
     * @return 响应
     */
    RecordTaskDetailResponse getRecordTask(RecordTaskDetailRequest request);

    /**
     * 获取手动录像任务列表
     *
     * @param request 请求
     * @return 响应
     */
    RecordTaskListResponse getRecordTaskList(RecordTaskListRequest request);
}
