package com.allcam.mss.ability.media;

import com.allcam.mss.ability.media.request.StreamProxyRequest;
import com.allcam.mss.ability.media.request.StreamProxyResponse;
import com.allcam.mss.ability.media.request.VodPlayUrlRequest;
import com.allcam.mss.ability.media.request.VodPlayUrlResponse;

/**
 * @author Beowulf
 */
public interface MediaPlayService
{

    /**
     * 获取视频点播地址
     *
     * @param fileId 文件编号
     * @param type   类型，rtmp或者hls
     * @return 点播地址
     */
    String buildVodUrl(String fileId, int type);

    /**
     * 获取视频点播地址, 失败则返回null
     *
     * @param fileId 文件编号
     * @param type   类型，rtmp或者hls
     * @return 点播地址
     */
    String optVodUrl(String fileId, int type);

    /**
     * 获取视频点播地址
     *
     * @param request 获取请求
     * @return 获取响应
     */
    VodPlayUrlResponse getVodUrl(VodPlayUrlRequest request);

    /**
     * 获取RTMP代理地址
     *
     * @param request 获取请求
     * @return 获取响应
     */
    StreamProxyResponse getStreamProxyUrl(StreamProxyRequest request);
}
