package com.allcam.mss.ability.media;

import com.allcam.mss.ability.media.request.VideoCaptureRequest;
import com.allcam.mss.ability.media.request.VideoCaptureResponse;

/**
 * @author Beowulf
 */
public interface MediaCoverService
{

    /**
     * 视频截取，可截取图片，动图，和视频
     *
     * @param request 请求
     * @return 响应
     */
    VideoCaptureResponse videoCapture(VideoCaptureRequest request);

    /**
     * 获取视频流缩略图地址，失败报异常
     *
     * @param videoUrl 视频流播放地址
     * @return 缩略图URL地址
     */
    String getStreamThumbnailUrl(String videoUrl);

    /**
     * 获取视频流截图地址，失败则返回默认值
     *
     * @param videoUrl 视频流播放地址
     * @param defValue 默认值
     * @return 截图URL地址
     */
    String optStreamThumbnailUrl(String videoUrl, String defValue);

    /**
     * 获取视频文件缩略图地址，失败报异常
     *
     * @param fileId 视频文件ID
     * @return 缩略图URL地址
     */
    String getVideoThumbnailUrl(String fileId);

    /**
     * 获取视频文件截图地址，失败则返回默认值
     *
     * @param fileId   视频文件ID
     * @param defValue 默认值
     * @return 截图URL地址
     */
    String optVideoThumbnailUrl(String fileId, String defValue);

    /**
     * 获取抓拍图片地址
     * 使用allmedia包装抓拍图片，可以处理压缩的图片流，缓存抓拍图片
     *
     * @param sourceUrl 抓拍原图
     * @param fileName  抓拍保存文件名
     * @return 包装的抓拍图片地址
     */
    String getWrappedSnapUrl(String sourceUrl, String fileName);
}
