package com.allcam.mss.ability.join.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VideoMosaicStartRequest extends BaseRequest
{

    private static final long serialVersionUID = 4380212632877659083L;

    /**
     * 任务回调url
     */
    @Verification(type = VerifyType.HAS_SIZE)
    private String callbackUrl;

    /**
     * 需要拼接的视频信息列表
     */
    @Verification(type = VerifyType.HAS_SIZE)
    private List<VodInfo> vodInfoList;

    public VideoMosaicStartRequest()
    {
        super();
    }

    public String getCallbackUrl()
    {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl)
    {
        this.callbackUrl = callbackUrl;
    }

    public List<VodInfo> getVodInfoList()
    {
        return vodInfoList;
    }

    public void setVodInfoList(List<VodInfo> vodInfoList)
    {
        this.vodInfoList = vodInfoList;
    }

}
