package com.allcam.mss.ability.constant;

/**
 * @author Beowulf
 */
public enum UrlType
{
    /**
     * 视频点播类型：RTMP
     */
    RTMP(1),

    /**
     * 视频点播类型：HLS
     */
    HLS(2),

    /**
     * 视频点播类型：RTSP
     */
    RTSP(3),

    /**
     * 视频点播类型：FLV+HTTP
     */
    FLV(4),

    /**
     * 视频点播类型：DASH
     */
    DASH(5);

    int type;

    UrlType(int type)
    {
        this.type = type;
    }

    public int getType()
    {
        return type;
    }

    public static UrlType of(int type)
    {
        for (UrlType value : values())
        {
            if (value.type == type)
            {
                return value;
            }
        }
        return null;
    }
}
