package com.allcam.mss.ability.constant;

import com.allcam.common.constant.ErrorCode;

/**
 * 业务错误码 <br/>
 * MSS媒体：3开头 <br/>
 * 公共错误：     300000 ~ 300999 <br/>
 * 媒体存储：     301000 ~ 301999 <br/>
 * 媒体拼接：     302000 ~ 302999 <br/>
 * 媒体剪辑：     303000 ~ 303999 <br/>
 * 媒体播放：     304000 ~ 304999 <br/>
 * 媒体转码：     305000 ~ 305999 <br/>
 * 媒体通知：     306000 ~ 306999 <br/>
 *
 * @author Beowulf
 */
public interface MssError extends ErrorCode
{

    /**
     * 公共错误：AllMedia节点不存在
     */
    int ACS_MSS_ALLMEDIA_NODE_NOT_EXIST = 300001;

    /**
     * 公共错误：zookeeper未连接
     */
    int ACS_MSS_ZOOKEEPER_NOT_CONNECT = 300002;

    /**
     * 公共错误：AllMedia节点满负载
     */
    int ACS_MSS_ALLMEDIA_NODE_FULL_LOAD = 300003;


    /**
     * 媒体存储：媒体文件不存在
     */
    int ACS_STORAGE_OBJECT_NOT_EXIST = 301001;

    /**
     * 媒体存储：媒体文件未上传
     */
    int ACS_STORAGE_OBJECT_NOT_UPLOAD = 301002;


    /**
     * 媒体剪辑：视频分割任务不存在
     */
    int ACS_MEDIA_SPLIT_TASK_NOT_EXIST = 303001;

    /**
     * 媒体剪辑：分割文件不合法
     */
    int ACS_MEDIA_SPLIT_FILE_ILLEGAL = 303002;

    /**
     * 媒体剪辑：分割文件时长超限
     */
    int ACS_MEDIA_DURATION_OVER_MAX = 303003;

    /**
     * 媒体剪辑：裁剪视频未指定时长
     */
    int ACS_MEDIA_RECORD_NO_DURATION = 303004;

    /**
     * 媒体剪辑：视频录制任务不存在
     */
    int ACS_MEDIA_RECORD_TASK_NOT_EXIST = 303101;


    /**
     * 媒体转码：镜头转码任务已存在
     */
    int ACS_CAMERA_TRANSCODE_TASK_ALREADY_EXIST = 305001;

    /**
     * 媒体转码：直播源转码任务已存在
     */
    int ACS_LIVE_TRANSCODE_TASK_ALREADY_EXIST = 305002;

    /**
     * 媒体转码：转码模板不存在
     */
    int ACS_TRANSCODE_TASK_NOT_EXIST = 305101;

    /**
     * 媒体转码：转码模板不存在
     */
    int ACS_TRANSCODE_TEMPLATE_NOT_EXIST = 305201;
}
