/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.verify;

import com.allcam.common.utils.verify.CollectionHolder;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class VerifyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyUtil.class);

    public static void validateParam(Object object) throws IllegalArgumentException {
        Assert.notNull((Object)object, (String)"object to validate is null.");
        VerifyUtil.validateParam(object, object.getClass());
    }

    private static void validateParam(Object object, Class objClass) throws IllegalArgumentException {
        Field[] fields;
        LOG.debug("validateParam objClass[{}]", (Object)objClass);
        if (!VerifyUtil.shouldVerify(objClass)) {
            LOG.debug("the class is not Allcam custom class, not need to validate.");
            return;
        }
        Class superClass = objClass.getSuperclass();
        VerifyUtil.validateParam(object, superClass);
        for (Field field : fields = objClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Verification.class)) continue;
            Verification antVerify = field.getAnnotation(Verification.class);
            VerifyUtil.validate(object, field, antVerify);
        }
    }

    private static void validate(Object object, Field field, Verification antVerify) {
        LOG.debug("validate field[{}]", (Object)field.getName());
        try {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Class<?> fClass = field.getType();
            Object valueObj = field.get(object);
            if (antVerify.nullable()) {
                if (valueObj == null) {
                    return;
                }
            } else if (Object.class.isAssignableFrom(fClass)) {
                String tip = antVerify.illegalTip();
                if (StringUtils.isEmpty((CharSequence)tip)) {
                    tip = field.getName() + "\u4e0d\u80fd\u4e3aNULL";
                }
                Assert.notNull((Object)valueObj, (String)tip);
            }
            if (valueObj instanceof String) {
                VerifyUtil.validateString((String)valueObj, antVerify, field);
            } else if (valueObj instanceof Byte) {
                LOG.debug("the field is *byte*, not need to validate.");
            } else if (valueObj instanceof Number) {
                Number value = (Number)valueObj;
                VerifyUtil.validateNumber(value, antVerify, field);
            } else if (valueObj instanceof Boolean) {
                VerifyType vType = antVerify.type();
                if (vType == VerifyType.BOOL_TRUE) {
                    Assert.isTrue((boolean)((Boolean)valueObj), (String)VerifyUtil.tip(antVerify, field));
                }
            } else if (valueObj instanceof Character) {
                LOG.debug("the field is *char*, not need to validate.");
            } else if (valueObj instanceof Collection) {
                VerifyUtil.validateCollection(new CollectionHolder((Collection)valueObj), antVerify, field);
            } else if (valueObj instanceof Map) {
                VerifyUtil.validateCollection(new CollectionHolder((Map)valueObj), antVerify, field);
            } else if (VerifyUtil.shouldVerify(fClass)) {
                LOG.debug("the field is *Custom*, continue validate.");
                VerifyUtil.validateParam(valueObj);
            }
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("validate field get value occur IllegalAccessException.");
        }
    }

    private static void validateString(String value, Verification antVerify, Field field) {
        VerifyType vType = antVerify.type();
        String param = antVerify.param();
        switch (vType) {
            case HAS_TEXT: {
                Assert.hasText((String)value, (String)VerifyUtil.tip(antVerify, field));
                break;
            }
            case NOT_CONTAIN: {
                Assert.notNull((Object)value, (String)VerifyUtil.tip(antVerify, field));
                Assert.doesNotContain((String)value, (String)param, (String)VerifyUtil.tip(antVerify, field, param));
                break;
            }
            case MAX_SIZE: {
                int sParam = Integer.parseInt(param);
                Assert.notNull((Object)value, (String)VerifyUtil.tip(antVerify, field));
                Assert.isTrue((value.length() <= sParam ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, param));
                break;
            }
            case MIN_SIZE: {
                int lParam = Integer.parseInt(param);
                Assert.notNull((Object)value, (String)VerifyUtil.tip(antVerify, field));
                Assert.isTrue((value.length() >= lParam ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, param));
                break;
            }
            case REGULAR: {
                Assert.notNull((Object)value, (String)VerifyUtil.tip(antVerify, field));
                Assert.isTrue((boolean)value.matches(param), (String)VerifyUtil.tip(antVerify, field));
                break;
            }
            default: {
                Assert.hasLength((String)value, (String)VerifyUtil.tip(antVerify.illegalTip(), VerifyType.HAS_SIZE, field));
            }
        }
    }

    private static void validateNumber(Number number, Verification antVerify, Field field) {
        VerifyType vType = antVerify.type();
        double value = number.doubleValue();
        switch (vType) {
            case BETWEEN: {
                String maxStr;
                String avParam = antVerify.param();
                int spIndex = avParam.indexOf(44);
                String minStr = avParam.substring(0, spIndex);
                if (minStr.length() > 0) {
                    int min = Integer.parseInt(minStr);
                    Assert.isTrue((value >= (double)min ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, antVerify.param()));
                }
                if ((maxStr = avParam.substring(spIndex + 1)).length() <= 0) break;
                int max = Integer.parseInt(maxStr);
                Assert.isTrue((value <= (double)max ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, antVerify.param()));
                break;
            }
            default: {
                Assert.isTrue((value != 0.0 ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify.illegalTip(), VerifyType.NOT_ZERO, field));
            }
        }
    }

    private static void validateCollection(CollectionHolder collection, Verification antVerify, Field field) {
        String param = antVerify.param();
        switch (antVerify.type()) {
            case MAX_SIZE: {
                int max = Integer.parseInt(param);
                Assert.isTrue((collection.size() <= max ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, param));
                break;
            }
            case MIN_SIZE: {
                int min = Integer.parseInt(param);
                Assert.isTrue((collection.size() >= min ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify, field, param));
                break;
            }
            default: {
                Assert.isTrue((!collection.isEmpty() ? 1 : 0) != 0, (String)VerifyUtil.tip(antVerify.illegalTip(), VerifyType.HAS_SIZE, field));
            }
        }
    }

    private static boolean shouldVerify(Class vClass) {
        return vClass.getName().startsWith("com.allcam");
    }

    private static String tip(Verification antVerify, Field field) {
        return VerifyUtil.tip(antVerify, field, null);
    }

    private static String tip(Verification antVerify, Field field, String param) {
        return VerifyUtil.tip(antVerify.illegalTip(), antVerify.type(), field, param);
    }

    private static String tip(String illegalTip, VerifyType vType, Field field) {
        return VerifyUtil.tip(illegalTip, vType, field, null);
    }

    private static String tip(String illegalTip, VerifyType vType, Field field, String param) {
        return illegalTip.isEmpty() ? vType.makeTip(field, param) : illegalTip;
    }
}

