/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.tree;

import com.allcam.common.base.AcBaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class JsTree
extends AcBaseBean {
    private static final long serialVersionUID = -1729942394944545519L;
    private String id;
    private String parentId;
    private String text;
    private String type;
    private Object payload;
    private State state = new State();
    private boolean relation;
    private List<JsTree> children = new ArrayList<JsTree>();

    public static List<JsTree> buildTree(List<JsTree> treeNodes) {
        ArrayList<JsTree> list = new ArrayList<JsTree>();
        for (JsTree treeNode : treeNodes) {
            JsTree.build(treeNode, treeNodes);
        }
        for (JsTree treeNode : treeNodes) {
            if (treeNode.isRelation()) continue;
            list.add(treeNode);
        }
        return list;
    }

    private static void build(JsTree treeNode, List<JsTree> treeNodes) {
        List<JsTree> children = JsTree.getChildren(treeNode, treeNodes);
        if (!children.isEmpty()) {
            treeNode.setChildren(children);
            for (JsTree child : children) {
                JsTree.build(child, treeNodes);
            }
        }
    }

    private static List<JsTree> getChildren(JsTree treeNode, List<JsTree> treeNodes) {
        ArrayList<JsTree> children = new ArrayList<JsTree>();
        String id = treeNode.getId();
        for (JsTree child : treeNodes) {
            if (!id.equals(child.getParentId())) continue;
            children.add(child);
            child.setRelation(true);
        }
        return children;
    }

    public JsTree(String id, String parentId, String text, String type) {
        this.id = id;
        this.parentId = parentId;
        this.text = text;
        this.type = type;
    }

    public void addChild(JsTree jsTree) {
        if (null == jsTree) {
            return;
        }
        if (null == this.children) {
            this.children = new ArrayList<JsTree>();
        }
        this.children.add(jsTree);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isRelation() {
        return this.relation;
    }

    public void setRelation(boolean relation) {
        this.relation = relation;
    }

    public List<JsTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<JsTree> children) {
        this.children = children;
    }

    public static class State
    extends AcBaseBean {
        private static final long serialVersionUID = -658404076169153567L;
        private int opened;
        private int selected;
        private int checked;
        private int disabled;

        public State() {
            this(0, 0, 0);
        }

        public State(int opened, int selected, int disabled) {
            this(opened, selected, selected, disabled);
        }

        public State(int opened, int selected, int checked, int disabled) {
            this.opened = opened;
            this.selected = selected;
            this.checked = checked;
            this.disabled = disabled;
        }

        @JsonIgnore
        public State open() {
            this.opened = 1;
            return this;
        }

        @JsonIgnore
        public State select() {
            this.selected = 1;
            return this;
        }

        @JsonIgnore
        public State check() {
            this.checked = 1;
            return this;
        }

        @JsonIgnore
        public State disable() {
            this.disabled = 1;
            return this;
        }

        public int getOpened() {
            return this.opened;
        }

        public void setOpened(int opened) {
            this.opened = opened;
        }

        public int getSelected() {
            return this.selected;
        }

        public void setSelected(int selected) {
            this.selected = selected;
        }

        public int getChecked() {
            return this.checked;
        }

        public void setChecked(int checked) {
            this.checked = checked;
        }

        public int getDisabled() {
            return this.disabled;
        }

        public void setDisabled(int disabled) {
            this.disabled = disabled;
        }
    }
}

