/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.tree;

import com.allcam.common.utils.tree.BranchProxy;
import com.allcam.common.utils.tree.JsTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import org.springframework.util.CollectionUtils;

public class Branch<T, V, E> {
    private Branch<T, V, E> parent;
    private List<Branch<T, V, E>> children = new ArrayList<Branch<T, V, E>>();
    private List<V> leaves = null;
    private int leafCount = 0;
    private int depth = 0;
    private T payload;
    private BranchProxy<T, E> branchProxy;

    Branch(BranchProxy<T, E> branchProxy, T payload) {
        this.branchProxy = branchProxy;
        this.payload = payload;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Branch<T, V, E> makeRoot() {
        this.parent = null;
        this.branchProxy.branchReset(this.payload, null);
        return this;
    }

    public void addChild(Branch<T, V, E> childNode) {
        if (childNode != null) {
            childNode.parent = this;
            super.reCountDepth();
            this.children.add(childNode);
        }
    }

    private void reCountDepth() {
        if (!this.isRoot()) {
            this.depth = this.parent.depth + 1;
        }
        for (Branch<T, V, E> child : this.children) {
            super.reCountDepth();
        }
    }

    public void collectAllChildrenLeaves(Collection<V> childrenLeaves) {
        if (!this.children.isEmpty()) {
            for (Branch<T, V, E> child : this.children) {
                child.collectAllChildrenLeaves(childrenLeaves);
            }
        }
        if (!CollectionUtils.isEmpty(this.leaves)) {
            childrenLeaves.addAll(this.leaves);
        }
    }

    public void collectAllSelectBranch(Collection<E> childrenBranchMarks, Set<E> selects) {
        if (selects.contains(this.branchProxy.branchMark(this.payload))) {
            ArrayList list = new ArrayList();
            this.collectAllChildrenBranchMark(list);
            childrenBranchMarks.addAll(list);
        } else if (!this.children.isEmpty()) {
            for (Branch child : this.children) {
                child.collectAllSelectBranch(childrenBranchMarks, selects);
            }
        }
    }

    public void collectAllChildrenBranchMark(Collection<E> childrenBranchMarks) {
        if (!this.children.isEmpty()) {
            for (Branch<T, V, E> child : this.children) {
                child.collectAllChildrenBranchMark(childrenBranchMarks);
            }
        }
        childrenBranchMarks.add(this.branchProxy.branchMark(this.payload));
    }

    public void collectAllChildrenPayloads(Collection<T> childrenPayloads) {
        if (!this.children.isEmpty()) {
            for (Branch<T, V, E> child : this.children) {
                child.collectAllChildrenPayloads(childrenPayloads);
            }
        }
        childrenPayloads.add(this.payload);
    }

    public void collectAllChildren(Collection<Branch<T, V, E>> childrenCollection) {
        if (!this.children.isEmpty()) {
            for (Branch<T, V, E> child : this.children) {
                child.collectAllChildren(childrenCollection);
            }
        }
        childrenCollection.add(this);
    }

    public int countTotalLeaves() {
        int leavesCount = 0;
        if (!this.children.isEmpty()) {
            for (Branch<T, V, E> child : this.children) {
                leavesCount += child.countTotalLeaves();
            }
        }
        return leavesCount += this.leafCount;
    }

    public void cutNakedBranches() {
        if (!this.isRoot() && this.countTotalLeaves() == 0) {
            this.parent.children.remove(this);
        } else {
            for (Branch<T, V, E> child : this.getChildrenArray()) {
                child.cutNakedBranches();
            }
        }
    }

    public void cutIfNaked() {
        if (!this.isRoot() && this.isNaked()) {
            this.parent.children.remove(this);
        }
    }

    public boolean isNaked() {
        return this.childrenCount() + this.getLeafCount() == 0;
    }

    public int childrenCount() {
        return this.children.size();
    }

    public Branch<T, V, E> getChildAt(int index) {
        return this.children.get(index);
    }

    public Branch<T, V, E> getChildOf(T payload) {
        for (Branch<T, V, E> child : this.children) {
            if (child.payload != payload) continue;
            return child;
        }
        return null;
    }

    public List<Branch<T, V, E>> getChildrenArray() {
        return new ArrayList<Branch<T, V, E>>(this.children);
    }

    public List<V> getAllChildrenLeaves() {
        ArrayList leaves = new ArrayList();
        this.collectAllChildrenLeaves(leaves);
        return leaves;
    }

    public List<T> getAllChildrenPayloads() {
        ArrayList payloads = new ArrayList();
        this.collectAllChildrenPayloads(payloads);
        return payloads;
    }

    public List<T> getChildrenPayloads() {
        ArrayList<T> payloads = new ArrayList<T>(this.childrenCount());
        for (Branch<T, V, E> child : this.children) {
            payloads.add(child.payload);
        }
        return payloads;
    }

    public Branch<T, V, E> findByMark(E mark) {
        if (null == mark) {
            return null;
        }
        if (mark.equals(this.branchProxy.branchMark(this.payload))) {
            return this;
        }
        for (Branch<T, V, E> child : this.children) {
            Branch<T, V, E> branch = child.findByMark(mark);
            if (null == branch) continue;
            return branch;
        }
        return null;
    }

    public Branch<T, V, E> findParentOf(T payload) {
        if (this.payload == payload) {
            return this;
        }
        if (!this.isRoot()) {
            return this.parent.findParentOf(payload);
        }
        return null;
    }

    public List<Branch<T, V, E>> getAllParents() {
        Stack<Branch<T, V, E>> branchStack = new Stack<Branch<T, V, E>>();
        Branch<T, V, E> nowBranch = this;
        while (!nowBranch.isRoot()) {
            nowBranch = nowBranch.parent;
            branchStack.push(nowBranch);
        }
        ArrayList list = new ArrayList();
        while (!branchStack.isEmpty()) {
            list.add(branchStack.pop());
        }
        return list;
    }

    public List<T> getAllParentPayloads() {
        Stack<T> branchStack = new Stack<T>();
        Branch<T, V, E> nowBranch = this;
        while (!nowBranch.isRoot()) {
            nowBranch = nowBranch.parent;
            branchStack.push(nowBranch.getPayload());
        }
        ArrayList list = new ArrayList();
        while (!branchStack.isEmpty()) {
            list.add(branchStack.pop());
        }
        return list;
    }

    public void setHasLeaf() {
        this.setLeafCount(1);
    }

    public void addLeaf(V leaf) {
        if (null == this.leaves) {
            this.leaves = new ArrayList<V>();
        }
        this.leaves.add(leaf);
        this.setLeafCount(this.leaves.size());
    }

    public void removeLeaf(V leaf) {
        if (null != this.leaves) {
            this.leaves.remove(leaf);
            this.setLeafCount(this.leaves.size());
        }
    }

    public void setLeaves(List<V> leaves) {
        this.leaves = leaves;
        this.setLeafCount(null == leaves ? 0 : leaves.size());
    }

    public void addLeaves(List<V> leaves) {
        if (null == this.leaves) {
            this.setLeaves(leaves);
        } else {
            this.leaves.addAll(leaves);
            this.setLeafCount(this.leaves.size());
        }
    }

    public int getLeafCount() {
        return this.leafCount;
    }

    public void setLeafCount(int leafCount) {
        this.leafCount = leafCount;
    }

    public V getLeafAt(int index) {
        if (null == this.leaves || index >= this.leafCount) {
            return null;
        }
        return this.leaves.get(index);
    }

    public Branch<T, V, E> getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public T getPayload() {
        return this.payload;
    }

    public JsTree buildJsTree(Function<T, JsTree> branchBuilder) {
        return this.buildJsTree(branchBuilder, null);
    }

    public JsTree buildJsTree(Function<T, JsTree> branchBuilder, Function<V, JsTree> leafBuilder) {
        JsTree jsTree = branchBuilder.apply(this.payload);
        for (Branch<T, V, E> child : this.children) {
            jsTree.addChild(child.buildJsTree(branchBuilder, leafBuilder));
        }
        if (null != leafBuilder && !CollectionUtils.isEmpty(this.leaves)) {
            for (Branch<T, V, E> leaf : this.leaves) {
                jsTree.addChild(leafBuilder.apply(leaf));
            }
        }
        return jsTree;
    }
}

