/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.tree;

import com.allcam.common.utils.tree.Branch;
import com.allcam.common.utils.tree.BranchProxy;
import com.allcam.common.utils.tree.LeafProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AnyTree<T, V, E> {
    private T backRoot;
    private Branch<T, V, E> treeRoot;
    private List<Branch<T, V, E>> branches = new ArrayList<Branch<T, V, E>>();
    private List<T> flatNodeList = new ArrayList<T>();
    private boolean markChanged = true;
    private BranchProxy<T, E> branchProxy;
    private LeafProxy<V, E> leafProxy;

    public AnyTree(BranchProxy<T, E> branchProxy, LeafProxy<V, E> leafProxy) {
        this.branchProxy = branchProxy;
        this.leafProxy = leafProxy;
    }

    public AnyTree<T, V, E> createTree(Collection<? extends T> flatTree) {
        return this.createTree(flatTree, null);
    }

    public AnyTree<T, V, E> createTree(Collection<? extends T> flatTree, T backRoot) {
        return this.createTree(flatTree, backRoot, false);
    }

    public AnyTree<T, V, E> createTree(Collection<? extends T> flatTree, T backRoot, boolean forceRoot) {
        this.backRoot = backRoot;
        if (flatTree != null && !flatTree.isEmpty()) {
            HashMap<E, T> nodeMap = new HashMap<E, T>(16);
            HashMap<Object, List> nodeGroupMap = new HashMap<Object, List>(16);
            for (T item : flatTree) {
                nodeMap.put(this.branchProxy.branchMark(item), item);
                List children = nodeGroupMap.computeIfAbsent(this.branchProxy.branchFrom(item), k -> new ArrayList());
                children.add(item);
            }
            Set nodeIdSet = nodeMap.keySet();
            ArrayList foundRoots = new ArrayList();
            HashMap<Object, Branch<T, V, E>> branchMap = new HashMap<Object, Branch<T, V, E>>(16);
            for (Object groupId : nodeGroupMap.keySet()) {
                if (nodeIdSet.contains(groupId)) {
                    Object groupItem = nodeMap.get(groupId);
                    branchMap.put(groupId, new Branch(this.branchProxy, groupItem));
                    continue;
                }
                foundRoots.addAll((Collection)nodeGroupMap.get(groupId));
            }
            Object rootNode = this.handleFilterRoots(foundRoots, forceRoot);
            this.treeRoot = new Branch(this.branchProxy, rootNode);
            branchMap.put(this.branchProxy.branchMark(rootNode), this.treeRoot);
            for (Map.Entry entry : nodeGroupMap.entrySet()) {
                Branch branch = (Branch)branchMap.get(entry.getKey());
                if (null == branch) {
                    branch = this.treeRoot;
                }
                for (Object t : (List)entry.getValue()) {
                    Branch child = (Branch)branchMap.get(this.branchProxy.branchMark(t));
                    if (null == child) {
                        child = new Branch(this.branchProxy, t);
                    }
                    if (branch == child) continue;
                    branch.addChild(child);
                }
            }
        } else {
            this.treeRoot = new Branch(this.branchProxy, backRoot);
        }
        this.markChange();
        this.reloadBranches();
        return this;
    }

    public AnyTree<T, V, E> bindLeaves(Set<E> branchIdSet) {
        this.branches.stream().filter(branch -> branchIdSet.contains(this.branchProxy.branchMark(branch.getPayload()))).forEach(Branch::setHasLeaf);
        return this;
    }

    public AnyTree<T, V, E> decorateLeaves(Collection<? extends V> leaves) {
        if (null == this.leafProxy) {
            throw new IllegalStateException("leaf proxy not config.");
        }
        HashMap<Object, List> leafMap = new HashMap<Object, List>(16);
        for (V v : leaves) {
            List branchLeaves = leafMap.computeIfAbsent(this.leafProxy.branchMark(v), k -> new ArrayList());
            branchLeaves.add(v);
        }
        for (Branch branch : this.branches) {
            E branchMark = this.branchProxy.branchMark(branch.getPayload());
            branch.setLeaves((List)leafMap.remove(branchMark));
        }
        for (Map.Entry entry : leafMap.entrySet()) {
            this.treeRoot.addLeaves((List)entry.getValue());
        }
        return this;
    }

    public AnyTree<T, V, E> simplifyRoot() {
        while (this.treeRoot.childrenCount() == 1) {
            Branch<T, V, E> nextRoot = this.treeRoot.getChildAt(0);
            this.treeRoot = nextRoot.makeRoot();
        }
        this.markChange();
        return this;
    }

    public AnyTree<T, V, E> cutNakedBranches() {
        this.treeRoot.cutNakedBranches();
        this.markChange();
        return this;
    }

    public List<Branch<T, V, E>> getBranchesUnderDepth(int depth) {
        ArrayList<Branch<T, V, Branch<T, V, E>>> list = new ArrayList<Branch<T, V, Branch<T, V, E>>>();
        for (Branch<T, V, E> branch : this.branches) {
            if (branch.getDepth() <= depth) continue;
            list.add(branch);
        }
        return list;
    }

    public Branch<T, V, E> getTreeRoot() {
        this.reloadBranches();
        return this.treeRoot;
    }

    public List<T> getFlatNodeList() {
        this.reloadBranches();
        return this.flatNodeList;
    }

    public List<Branch<T, V, E>> getBranches() {
        return new ArrayList<Branch<T, V, E>>(this.branches);
    }

    public Branch<T, V, E> addBranch(Branch<T, V, E> parent, T child) {
        Branch branch = new Branch(this.branchProxy, child);
        parent.addChild(branch);
        return branch;
    }

    private void markChange() {
        this.markChanged = true;
    }

    private void reloadBranches() {
        if (this.markChanged) {
            this.markChanged = false;
            this.branches.clear();
            if (null == this.treeRoot) {
                this.treeRoot = new Branch(this.branchProxy, this.backRoot);
            } else {
                this.treeRoot.makeRoot().collectAllChildren(this.branches);
            }
            this.flatNodeList.clear();
            this.branches.sort(Comparator.comparing(Branch::getDepth));
            for (Branch<T, V, E> branch : this.branches) {
                this.flatNodeList.add(branch.getPayload());
            }
        }
    }

    private T handleFilterRoots(List<T> foundRoots, boolean forceRoot) {
        if (foundRoots.isEmpty()) {
            throw new IllegalStateException("there is no root found in this tree.");
        }
        if (!forceRoot && foundRoots.size() == 1) {
            return foundRoots.get(0);
        }
        if (null == this.backRoot) {
            throw new IllegalStateException("there is more than one root found in this tree.");
        }
        for (T found : foundRoots) {
            this.branchProxy.branchReset(found, this.branchProxy.branchMark(this.backRoot));
        }
        return this.backRoot;
    }

    private boolean match(T asChild, T asParent) {
        E a = this.branchProxy.branchFrom(asChild);
        E b = this.branchProxy.branchMark(asParent);
        return Objects.equals(a, b);
    }
}

