/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.query;

import com.allcam.common.model.OrderInfo;
import com.allcam.common.utils.query.FieldProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QueryOrderUtils {
    public static List<OrderInfo> orders(int ... fields) {
        ArrayList<OrderInfo> list = new ArrayList<OrderInfo>(fields.length);
        for (int field : fields) {
            list.add(new OrderInfo(field));
        }
        return list;
    }

    public static String buildOrderString(List<OrderInfo> orderList, FieldProvider provider) {
        if (CollectionUtils.isEmpty(orderList)) {
            return null;
        }
        StringBuilder sb = null;
        for (OrderInfo order : orderList) {
            if (null == sb) {
                sb = new StringBuilder();
            } else {
                sb.append(", ");
            }
            sb.append(provider.getFieldName(order.getField())).append(" ").append(order.getOrder() == 1 ? "ASC" : "DESC");
        }
        return null == sb ? null : sb.toString();
    }
}

