/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;

public final class PropertiesResource {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesResource.class);
    private static final Map<String, Properties> PROPERTIES_MAP = new HashMap<String, Properties>();

    public static void initFromFile(String name, String path) throws IOException {
        Assert.hasText((String)name, (String)"init name is empty.");
        Assert.hasText((String)path, (String)"init path is empty.");
        Properties properties = new Properties();
        PROPERTIES_MAP.put(name, properties);
        PropertiesResource.init(properties, new ClassPathResource(path).getInputStream());
    }

    public static void initFromText(String name, String text) {
        Assert.hasText((String)name, (String)"init name is empty.");
        Assert.hasText((String)text, (String)"init text is empty.");
        Properties properties = new Properties();
        PROPERTIES_MAP.put(name, properties);
        PropertiesResource.init(properties, new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
    }

    private static void init(Properties properties, InputStream stream) {
        LOG.info("init properties begin.");
        Assert.notNull((Object)stream, (String)"input stream is null.");
        try (InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            properties.load(isr);
            LOG.info("init properties data ok.");
        }
        catch (Exception e) {
            LOG.error("init properties data fail", (Throwable)e);
            throw new IllegalStateException("init properties data fail");
        }
    }

    public static boolean contains(String name) {
        Assert.hasText((String)name, (String)"name is empty");
        return PROPERTIES_MAP.containsKey(name);
    }

    public static Properties getProperties(String name) {
        return PROPERTIES_MAP.get(name);
    }

    public static void setProperty(String name, String key, String value) {
        LOG.debug("set mapper properties name=[{}] key=[{}] value=[{}].", new Object[]{name, key, value});
        Assert.hasText((String)name, (String)"name is empty");
        Assert.hasText((String)key, (String)"key is empty");
        Assert.hasText((String)value, (String)"value is empty");
        Properties properties = PROPERTIES_MAP.get(name);
        if (null == properties) {
            properties = new Properties();
            PROPERTIES_MAP.put(name, properties);
        }
        properties.setProperty(key, value);
    }

    public static String getString(String name, String key) {
        return PropertiesResource.getString(name, key, "");
    }

    public static String getString(String name, String key, String defaultValue) {
        Assert.hasText((String)name, (String)"name is empty.");
        Assert.hasText((String)key, (String)"key is empty.");
        Properties properties = PROPERTIES_MAP.get(name);
        if (null == properties) {
            return defaultValue;
        }
        return properties.getProperty(key, defaultValue);
    }
}

