/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

public class Tools {
    private static final Logger LOG = LoggerFactory.getLogger(Tools.class);
    private static ConversionService conversionService = new DefaultConversionService();

    public static void changeFieldValue(Object bean, String fieldName, Object fieldValue) {
        LOG.debug("change field value with name[{}] and value[{}]", (Object)fieldName, fieldValue);
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)fieldName);
            if (null != pd) {
                Class<?> target = pd.getPropertyType();
                if (target.isPrimitive()) {
                    Object array = Array.newInstance(target, 1);
                    target = Array.get(array, 0).getClass();
                }
                fieldValue = conversionService.convert(fieldValue, target);
                Method writeMethod = pd.getWriteMethod();
                writeMethod.invoke(bean, fieldValue);
                LOG.debug("change field value finish.", (Object)fieldName, fieldValue);
            }
        }
        catch (Exception e) {
            LOG.error("change field value fail.", (Throwable)e);
        }
    }

    public static boolean updateFieldValue(Object target, Object modify) {
        Assert.notNull((Object)target, (String)"target must not be null");
        Assert.notNull((Object)modify, (String)"source must not be null");
        Class<?> targetClass = target.getClass();
        Class<?> modifyClass = modify.getClass();
        Assert.isTrue((boolean)targetClass.equals(modifyClass), (String)"target and modify must be the same class");
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(targetClass);
        if (null == targetPds || targetPds.length == 0) {
            return false;
        }
        boolean modified = false;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod = targetPd.getReadMethod();
            Method writeMethod = targetPd.getWriteMethod();
            if (readMethod == null || writeMethod == null) continue;
            try {
                Object targetValue;
                Object modifyValue;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((modifyValue = readMethod.invoke(modify, new Object[0])) == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                if ((targetValue = readMethod.invoke(target, new Object[0])) == null) {
                    modified = true;
                    writeMethod.invoke(target, modifyValue);
                    continue;
                }
                Class<?> fieldCls = targetValue.getClass();
                if (fieldCls.isPrimitive() || Modifier.isFinal(fieldCls.getModifiers())) {
                    if (modifyValue.equals(targetValue)) continue;
                    modified = true;
                    writeMethod.invoke(target, modifyValue);
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldCls) || fieldCls.isArray()) {
                    modified = true;
                    writeMethod.invoke(target, modifyValue);
                    continue;
                }
                boolean subModified = Tools.updateFieldValue(targetValue, modifyValue);
                modified = modified || subModified;
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not set property '" + targetPd.getName() + "' from modify to target", ex);
            }
        }
        return modified;
    }

    public static <T> T getCastObject(Class<T> c, Object obj) {
        if (null == obj || null == c) {
            return null;
        }
        T body = null;
        if (c.isInstance(obj)) {
            try {
                body = c.cast(obj);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        return body;
    }
}

