/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final char HYPHEN = '-';
    private static Pattern ipPattern = Pattern.compile("(?<=//|)((\\w)+\\.)+\\w+");

    public static String getIpFromUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        String host = "";
        Matcher matcher = ipPattern.matcher(url);
        if (matcher.find()) {
            host = matcher.group();
        }
        return host;
    }

    public static String hyphenToCamel(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return "";
        }
        if (!param.contains(String.valueOf('-'))) {
            return param;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '-') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toLowerCase(String str) {
        if (null == str) {
            return null;
        }
        return str.toLowerCase(Locale.getDefault());
    }

    public static String toUpperCase(String str) {
        if (null == str) {
            return null;
        }
        return str.toUpperCase(Locale.getDefault());
    }

    public static boolean validate(String str) {
        return StringUtils.isNotBlank((CharSequence)str) && !"null".equalsIgnoreCase(str) && !"unknown".equalsIgnoreCase(str);
    }

    public static String trim(String arg) {
        if (null == arg) {
            return null;
        }
        return arg.trim();
    }

    public static String numToString(long number, int length) {
        return StringUtil.alignString(Long.toString(number), length);
    }

    public static String alignString(String str, int length) {
        return StringUtil.alignString(str, length, false);
    }

    public static String alignString(String str, char repeat, int length) {
        return StringUtil.alignString(str, repeat, length, false);
    }

    public static String alignString(String str, int length, boolean tooLargeException) {
        return StringUtil.alignString(str, '0', length, tooLargeException);
    }

    public static String alignString(String str, char repeat, int length, boolean tooLargeException) {
        int zeroLength = length - str.length();
        if (zeroLength < 0) {
            if (tooLargeException) {
                throw new IllegalArgumentException("string[" + str + "] is too long than the length[" + length + "]");
            }
            return str;
        }
        if (zeroLength == 0) {
            return str;
        }
        return StringUtils.repeat((char)repeat, (int)zeroLength) + str;
    }

    public static String toString(String str) {
        return null == str ? "" : str;
    }

    public static String appendStr(String ... stringArr) {
        if (null == stringArr || 0 == stringArr.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : stringArr) {
            sb.append(StringUtil.toString(str));
        }
        return sb.toString();
    }

    public static int toInt(String str, int defValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static String encodeEmoji(String orgStr) {
        if (StringUtils.isBlank((CharSequence)orgStr)) {
            return orgStr;
        }
        String temp = orgStr;
        Pattern pattern = Pattern.compile("[^\u0000-\uffff]", 66);
        Matcher matcher = pattern.matcher(orgStr);
        while (matcher.find()) {
            StringBuilder sb = new StringBuilder("[em:");
            String mStr = matcher.group();
            for (int i = 0; i < mStr.length(); ++i) {
                char emoji = mStr.charAt(i);
                if (i < mStr.length() - 1) {
                    sb.append((int)emoji).append('-');
                    continue;
                }
                sb.append((int)emoji).append(']');
            }
            temp = temp.replaceAll(mStr, sb.toString());
        }
        return temp;
    }

    public static String decodeEmoji(String orgStr) {
        if (StringUtils.isBlank((CharSequence)orgStr)) {
            return orgStr;
        }
        String temp = orgStr;
        Pattern pattern = Pattern.compile("\\[em:[\\d\\-]+\\]", 2);
        Matcher matcher = pattern.matcher(orgStr);
        while (matcher.find()) {
            StringBuilder sb = new StringBuilder("\\[em:");
            StringBuilder emojiSb = new StringBuilder();
            String mStr = matcher.group();
            String[] emojis = mStr.substring(4, mStr.length() - 1).split("-");
            for (int i = 0; i < emojis.length; ++i) {
                int emoji = Integer.parseInt(emojis[i]);
                emojiSb.append((char)emoji);
                if (i < emojis.length - 1) {
                    sb.append(emoji).append("\\-");
                    continue;
                }
                sb.append(emoji).append("\\]");
            }
            temp = temp.replaceAll(sb.toString(), emojiSb.toString());
        }
        return temp;
    }

    public static String handleHtmlTag(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return html;
        }
        return html.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static boolean equals(String left, String right) {
        return StringUtil.toString(left).equals(StringUtil.toString(right));
    }
}

