/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import com.allcam.common.utils.MD5;
import com.allcam.common.utils.RandomUtil;
import com.allcam.common.utils.StringUtil;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ServletUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServletUtil.class);
    public static final int NONCE_LENGTH = 34;
    public static final int NEXTNONCE_LENGTH = 34;
    public static final int OPAQUE_LENGTH = 34;
    private static final String DIGEST_METHOD = "POST";
    private static final String DIGEST_STARTER = "Digest ";
    private static final String X_DIGEST_STARTER = "xDigest ";

    public static void onResponseJson(HttpServletResponse response, String respString) {
        ServletUtil.onResponse(response, respString, "application/json");
    }

    public static void onResponseXml(HttpServletResponse response, String respString) {
        ServletUtil.onResponse(response, respString, "application/xml");
    }

    public static void onResponse(HttpServletResponse response, String respString, String contentType) {
        LOG.debug("send response: {}", (Object)respString);
        try {
            response.setStatus(200);
            response.setContentType(contentType);
            PrintWriter out = response.getWriter();
            out.println(respString);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOG.error("onResponse fail: ", (Throwable)e);
        }
    }

    public static String getLoginNameFromRequest(HttpServletRequest request) {
        String authHeader = ServletUtil.getAuthorization(request);
        if (StringUtil.validate(authHeader)) {
            String[] headers;
            for (String header : headers = authHeader.split("[,]")) {
                int sepIndex;
                if (!header.startsWith("username") || (sepIndex = header.indexOf("=")) <= 0) continue;
                String value = header.substring(sepIndex + 1);
                return value.replaceAll("\"", "");
            }
        }
        return null;
    }

    public static String buildUrlWithParams(String url, Map<String, String> params) {
        if (!CollectionUtils.isEmpty(params)) {
            StringBuilder strBuilder = new StringBuilder(url);
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                strBuilder.append(first ? (char)'?' : '&');
                strBuilder.append(entry.getKey()).append('=').append(entry.getValue());
                first = false;
            }
            url = strBuilder.toString();
        }
        return url;
    }

    public static String appendUrlWithParam(String url, String name, String value) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        String pChar = url.contains("?") ? "&" : "?";
        return url.concat(pChar).concat(name).concat("=").concat(value);
    }

    private static String getParamValue(String source, String key) {
        int sepIndex;
        if (null != source && source.startsWith(key) && (sepIndex = source.indexOf("=")) > 0) {
            String value = source.substring(sepIndex + 1);
            return value.replaceAll("\"", "");
        }
        return null;
    }

    public static DigestInfo getDigestInfo(HttpServletRequest request) {
        String authHeader = ServletUtil.getAuthorization(request);
        LOG.debug("Authorization Digest info: {}", (Object)authHeader);
        if (StringUtil.validate(authHeader)) {
            return new DigestInfo(authHeader);
        }
        return null;
    }

    public static String getAuthorizationType(HttpServletRequest request) {
        int spIndex;
        String authHeader;
        if (null != request && null != (authHeader = request.getHeader("Authorization")) && (spIndex = authHeader.indexOf(32)) > 0) {
            return authHeader.substring(0, spIndex + 1);
        }
        return DIGEST_STARTER;
    }

    public static String getAuthorization(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String authHeader = request.getHeader("Authorization");
        if (null != authHeader) {
            if (authHeader.startsWith(DIGEST_STARTER)) {
                authHeader = authHeader.substring(DIGEST_STARTER.length());
            }
            if (authHeader.startsWith(X_DIGEST_STARTER)) {
                authHeader = authHeader.substring(X_DIGEST_STARTER.length());
            }
        }
        return authHeader;
    }

    public static String getRequestIPAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (!StringUtil.validate(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (!StringUtil.validate(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (!StringUtil.validate(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String randomNonce() {
        return RandomUtil.randomString(34);
    }

    public static String generateResponse(String userName, String realm, String nonce, String url, String qop, String nc, String cnonce, String password, byte[] body) {
        String a1 = MD5.md5(ServletUtil.generateA1(userName, realm, password));
        String a2 = MD5.md5(ServletUtil.firstA2(qop, url, body));
        String genString = StringUtil.appendStr(a1, ":", nonce, ":", nc, ":", cnonce, ":", qop, ":", a2);
        return MD5.md5(genString);
    }

    private static String generateA1(String userName, String realm, String password) {
        return StringUtil.appendStr(userName, ":", realm, ":", password);
    }

    private static String firstA2(String qop, String url, byte[] body) {
        if ("auth".equals(qop)) {
            return "POST:" + url;
        }
        if ("auth-int".equals(qop)) {
            String entityBody;
            try {
                entityBody = new String(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                entityBody = new String(body);
            }
            return StringUtil.appendStr(DIGEST_METHOD, ":", url, ":", MD5.md5(entityBody));
        }
        return "";
    }

    public static class DigestInfo {
        private boolean isAppAuth = false;
        public String userNameAuth;
        public String responseAuth;
        public String nonceAuth;
        String uriAuth;
        String realmAuth;
        String cnonceAuth;
        String opaqueAuth;
        String qopAuth;
        String ncAuth;

        public DigestInfo(String authHeader) {
            String[] headers = authHeader.split("[,]");
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (String header : headers) {
                int sepIndex = header.indexOf("=");
                if (sepIndex <= 0) continue;
                String value = header.substring(sepIndex + 1);
                value = value.replaceAll("\"", "");
                valueMap.put(header.substring(0, sepIndex).trim(), value.trim());
            }
            String appId = (String)valueMap.get("appId");
            String username = (String)valueMap.get("username");
            this.realmAuth = (String)valueMap.get("realm");
            this.nonceAuth = (String)valueMap.get("nonce");
            this.uriAuth = (String)valueMap.get("uri");
            this.responseAuth = (String)valueMap.get("response");
            this.cnonceAuth = (String)valueMap.get("cnonce");
            this.opaqueAuth = (String)valueMap.get("opaque");
            this.qopAuth = (String)valueMap.get("qop");
            this.ncAuth = (String)valueMap.get("nc");
            this.isAppAuth = StringUtils.isNotEmpty((CharSequence)appId);
            this.userNameAuth = this.isAppAuth ? appId : username;
        }

        public boolean validate() {
            return StringUtils.isNotEmpty((CharSequence)this.responseAuth) && StringUtils.isNotEmpty((CharSequence)this.userNameAuth) && StringUtils.isNotEmpty((CharSequence)this.uriAuth) && StringUtils.isNotEmpty((CharSequence)this.nonceAuth);
        }

        public String genResponse(String passWord) {
            return ServletUtil.generateResponse(this.userNameAuth, this.realmAuth, this.nonceAuth, this.uriAuth, this.qopAuth, this.ncAuth, this.cnonceAuth, passWord, null);
        }

        public boolean isAppAuth() {
            return this.isAppAuth;
        }
    }
}

