/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class LunarCalendar {
    private static final int BASE_YEAR = 1900;
    private static final int MAX_YEAR = 2050;
    private static final int BASE_OFFSET_DAY = -25537;
    private static final String[] CHINESE_DAY_SUF = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
    private static final String[] CHINESE_GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] CHINESE_ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] CHINESE_ZODIAC = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] CHINESE_NUMBER = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u814a"};
    private static final long[] LUNAR_INFO = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    int mYear;
    int mMonth;
    int mDay;
    boolean isLeapYear = false;
    Calendar mCalendar;

    public LunarCalendar(Calendar calendar) {
        this.mCalendar = calendar;
        int offset = (int)(calendar.getTime().getTime() / 86400000L - -25537L);
        offset = this.calculateYear(offset);
        this.calculateMonthAndDate(offset);
    }

    private int calculateYear(int offset) {
        int cnYear;
        int daysOverYear = 0;
        for (cnYear = 1900; cnYear < 2050 && offset > 0; offset -= daysOverYear, ++cnYear) {
            daysOverYear = LunarCalendar.daysOverYear(cnYear);
        }
        if (offset < 0) {
            offset += daysOverYear;
            --cnYear;
        }
        this.mYear = cnYear;
        return offset;
    }

    private void calculateMonthAndDate(int offset) {
        int iMonth;
        int leapMonth = LunarCalendar.leapMonth(this.mYear);
        int daysOverMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.isLeapYear) {
                --iMonth;
                this.isLeapYear = true;
                daysOverMonth = LunarCalendar.leapDays(this.mYear);
            } else {
                daysOverMonth = LunarCalendar.daysOverMonth(this.mYear, iMonth);
            }
            offset -= daysOverMonth;
            if (!this.isLeapYear || iMonth != leapMonth + 1) continue;
            this.isLeapYear = false;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.isLeapYear) {
                this.isLeapYear = false;
            } else {
                this.isLeapYear = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOverMonth;
            --iMonth;
        }
        this.mMonth = iMonth;
        this.mDay = offset + 1;
    }

    public String getCnZodiacYear() {
        return CHINESE_ZODIAC[(this.mYear - 4) % CHINESE_ZODIAC.length];
    }

    public String getGanZhi() {
        int num = this.mYear - 1900 + 36;
        return CHINESE_GAN[num % CHINESE_GAN.length] + CHINESE_ZHI[num % CHINESE_ZHI.length];
    }

    public String getLunarMonthName() {
        return (this.isLeapYear ? "\u95f0" : "") + CHINESE_NUMBER[this.mMonth - 1] + "\u6708";
    }

    public String getLunarDayName() {
        int n;
        int day = this.mDay;
        int n2 = n = day % 10 == 0 ? 9 : day % 10 - 1;
        if (day < 40) {
            return CHINESE_DAY_SUF[day == 10 ? 0 : day / 10] + CHINESE_NUMBER[n];
        }
        return "";
    }

    public static int daysOverYear(int year) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((LUNAR_INFO[year - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + LunarCalendar.leapDays(year);
    }

    public static int daysOverMonth(int year, int month) {
        return (LUNAR_INFO[year - 1900] & (long)(65536 >> month)) == 0L ? 29 : 30;
    }

    public static int leapMonth(int year) {
        return (int)(LUNAR_INFO[year - 1900] & 0xFL);
    }

    public static int leapDays(int year) {
        if (LunarCalendar.leapMonth(year) == 0) {
            return 0;
        }
        return (LUNAR_INFO[year - 1900] & 0x10000L) == 0L ? 29 : 30;
    }

    public static void findSpringFestivalDate(Calendar calendar) {
        if (null == calendar) {
            return;
        }
        int offset = (int)(calendar.getTime().getTime() / 86400000L - -25537L);
        int daysOverYear = 0;
        for (int cnYear = 1900; cnYear < 2050 && offset > 0; offset -= daysOverYear, ++cnYear) {
            daysOverYear = LunarCalendar.daysOverYear(cnYear);
        }
        if (offset < 0) {
            offset += daysOverYear;
        }
        calendar.add(5, 0 - offset);
    }

    public static void findComingSpringFestivalDate(Calendar calendar) {
        if (null == calendar) {
            return;
        }
        int offset = (int)(calendar.getTime().getTime() / 86400000L - -25537L);
        for (int cnYear = 1900; cnYear < 2050 && offset >= 0; offset -= LunarCalendar.daysOverYear(cnYear), ++cnYear) {
        }
        calendar.add(5, 0 - offset);
    }

    public static Date getSpringFestivalDate(String date, boolean next) {
        Calendar c = Calendar.getInstance();
        try {
            Date pDate = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).parse(date);
            c.setTimeInMillis(pDate.getTime() + 43200000L);
            if (next) {
                LunarCalendar.findComingSpringFestivalDate(c);
            } else {
                LunarCalendar.findSpringFestivalDate(c);
            }
            c.set(11, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return c.getTime();
    }
}

