/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper LOG_OBJ_MAPPER = new ObjectMapper();
    private static final Logger LOG;

    public static String toJson(Object obj) {
        return JSONUtil.toJson(obj, false);
    }

    public static String toJson(Object obj, boolean pretty) {
        try {
            if (pretty) {
                return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.error("toJson fail: ", (Throwable)e);
            return "";
        }
    }

    public static <T> T fromJson(String jsonStr, Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clz);
        }
        catch (Exception e) {
            LOG.error("fromJson fail: ", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> jsonToMap(String jsonStr) {
        try {
            JavaType jvt = OBJECT_MAPPER.getTypeFactory().constructParametricType(HashMap.class, new Class[]{String.class, String.class});
            return (Map)OBJECT_MAPPER.readValue(jsonStr, jvt);
        }
        catch (Exception e) {
            LOG.error("jsonToMap fail: ", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    public static <T> List<T> jsonToList(String jsonStr, Class<T> clz) {
        try {
            JavaType jt = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clz});
            return (List)OBJECT_MAPPER.readValue(jsonStr, jt);
        }
        catch (IOException e) {
            LOG.error("jsonToList fail: ", (Throwable)e);
            return new ArrayList();
        }
    }

    public static String log(Object obj) {
        if (null == obj) {
            return "NULL";
        }
        try {
            return LOG_OBJ_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.error("log fail: ", (Throwable)e);
            return "";
        }
    }

    public static String makeLog(Object obj) {
        String body;
        if (null == obj) {
            return "NULL";
        }
        try {
            body = LOG_OBJ_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.error("makeLog fail: ", (Throwable)e);
            body = "";
        }
        return obj.getClass().getSimpleName() + ": " + body;
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(String.class, (JsonSerializer)new PwdFilterSerializer());
        LOG_OBJ_MAPPER.registerModule((Module)simpleModule);
        LOG_OBJ_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        LOG_OBJ_MAPPER.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        LOG_OBJ_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        LOG = LoggerFactory.getLogger(JSONUtil.class);
    }

    static class PwdFilterSerializer
    extends JsonSerializer<String> {
        PwdFilterSerializer() {
        }

        public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            String name = jsonGenerator.getOutputContext().getCurrentName();
            if (null != name && this.canFilter(name)) {
                jsonGenerator.writeString("******");
            } else {
                jsonGenerator.writeString(s);
            }
        }

        private boolean canFilter(String name) {
            return "pPWD".equals(name) || "password".equalsIgnoreCase(name) || name.endsWith("Password") || "passwd".equalsIgnoreCase(name) || name.endsWith("Passwd");
        }
    }
}

