/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import com.allcam.common.utils.LunarCalendar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.util.Pair;

public class DateUtil {
    public static final String YMD = "yyyyMMdd";
    public static final String HMS = "HHmmss";
    public static final String YM = "yyyy-MM";
    public static final String YMD_DASH = "yyyy-MM-dd";
    public static final String YMD_DOT = "yyyy.MM.dd";
    public static final String YMDH = "yyyy-MM-dd HH";
    public static final String YMDHM = "yyyy-MM-dd HH:mm";
    public static final String YMDHMS = "yyyyMMddHHmmss";
    public static final String YMDHMS_MS = "yyyyMMddHHmmssSSS";
    public static final String YMDHMS_STD = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHMS_STD_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DEFAULT_TIMESTAMP = "19700101000000";
    public static final long ONE_YEAR_MILLIS = 31536000000L;

    public static String nowYmdHms() {
        return DateUtil.now(YMDHMS);
    }

    public static String nowYmdHmsStd() {
        return DateUtil.now(YMDHMS_STD);
    }

    public static String now(String format) {
        return DateUtil.formatTime(new Date(), format);
    }

    public static String formatTime(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static long timeStr2Long(String time, String pattern) {
        return DateUtil.timeStr2Date(time, pattern).getTime();
    }

    public static String str2strDate(String dateStr, String basePatten, String convertPatten) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        return DateUtil.formatTime(DateUtil.timeStr2Date(dateStr, basePatten), convertPatten);
    }

    public static Date timeStr2Date(String time, String pattern) {
        if (time == null) {
            throw new IllegalArgumentException("time parameter can not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern parameter can not be null");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("using [" + pattern + "] parse [" + time + "] failed");
        }
    }

    public static String getNowWeekBegin() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        int dayPlus = dayOfWeek == 1 ? 0 : 1 - dayOfWeek;
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, dayPlus);
        Date sunday = currentDate.getTime();
        return DateUtil.formatTime(sunday, YMD_DASH);
    }

    public static String getNowWeekEnd() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        int dayPlus = dayOfWeek == 7 ? 0 : 7 - dayOfWeek;
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, dayPlus);
        Date saturday = currentDate.getTime();
        return DateUtil.formatTime(saturday, YMD_DASH);
    }

    public static int getMonthWeek(String dateTime) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(YMD_DASH);
        Date date = sdf.parse(dateTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(1);
        calendar.setTime(date);
        int week = calendar.get(4);
        return week;
    }

    public static long getBetweenDays(Date beginDate, Date endDate) {
        long beginTime = beginDate.getTime();
        long endTime = endDate.getTime();
        return (long)Math.ceil((double)(endTime - beginTime) / 8.64E7);
    }

    public static long getDuration(String begin, String end) {
        return DateUtil.getDuration(begin, end, YMDHMS_STD);
    }

    public static long getDuration(String begin, String end, String pattern) {
        Date beginTime = DateUtil.timeStr2Date(begin, pattern);
        Date endTime = DateUtil.timeStr2Date(end, pattern);
        return (long)Math.ceil((endTime.getTime() - beginTime.getTime()) / 1000L);
    }

    public static Date getSemesterBegin(String time, String format) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(time);
        String dayBreakTime = DateUtil.formatTime(date, YMD_DASH);
        Date dayBreakDate = new SimpleDateFormat(YMD_DASH).parse(dayBreakTime);
        Date springDate = LunarCalendar.getSpringFestivalDate(dayBreakTime, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayBreakDate);
        calendar.set(2, 8);
        calendar.set(5, 1);
        Date sepOneDate = calendar.getTime();
        if (!sepOneDate.after(dayBreakDate)) {
            return sepOneDate;
        }
        calendar.add(1, -1);
        Date lastYearSepOneDate = calendar.getTime();
        if (null != springDate && lastYearSepOneDate.after(springDate)) {
            return lastYearSepOneDate;
        }
        return springDate;
    }

    public static Date getSemesterEnd(String time, String format) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(time);
        String dayBreakTime = DateUtil.formatTime(date, YMD_DASH);
        Date dayBreakDate = new SimpleDateFormat(YMD_DASH).parse(dayBreakTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayBreakDate);
        calendar.set(2, 8);
        calendar.set(5, 1);
        Date sepOneDate = calendar.getTime();
        if (!sepOneDate.after(dayBreakDate)) {
            return LunarCalendar.getSpringFestivalDate(dayBreakTime, true);
        }
        calendar.add(1, -1);
        Date lastYearSepOneDate = calendar.getTime();
        Date springDate = LunarCalendar.getSpringFestivalDate(dayBreakTime, false);
        if (null != springDate && lastYearSepOneDate.after(springDate)) {
            return LunarCalendar.getSpringFestivalDate(dayBreakTime, true);
        }
        return sepOneDate;
    }

    public static String getYestodayDate(String format) {
        Calendar cd = Calendar.getInstance();
        cd.add(5, -1);
        Date yesterday = cd.getTime();
        return DateUtil.formatTime(yesterday, format);
    }

    public static String transDateBetweenTimeZone(String sourceDate, String format, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        return DateUtil.transDateBetweenTimeZone(DateUtil.timeStr2Date(sourceDate, format), format, sourceTimeZone, targetTimeZone);
    }

    public static String transDateBetweenTimeZone(Date sourceDate, String format, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        long targetTime = sourceDate.getTime() - (long)sourceTimeZone.getRawOffset() + (long)targetTimeZone.getRawOffset();
        return DateUtil.formatTime(new Date(targetTime), format);
    }

    public static Calendar fromDateStr(String dateStr, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.timeStr2Date(dateStr, format));
        return calendar;
    }

    public static List<Pair<String, String>> splitQueryDateFromTime(String beginTime, String endTime) {
        return DateUtil.splitQueryDateFromTime(beginTime, endTime, YMDHMS_STD);
    }

    public static List<Pair<String, String>> splitQueryDateFromTime(String beginTime, String endTime, String format) {
        Calendar bCalendar = DateUtil.fromDateStr(beginTime, format);
        Calendar eCalendar = DateUtil.fromDateStr(endTime, format);
        if (eCalendar.getTimeInMillis() - bCalendar.getTimeInMillis() > 31536000000L) {
            throw new IllegalArgumentException("time span must less than one year.");
        }
        ArrayList<Pair<String, String>> timeSpanList = new ArrayList<Pair<String, String>>();
        while (bCalendar.before(eCalendar)) {
            bCalendar.set(11, 23);
            bCalendar.set(12, 59);
            bCalendar.set(13, 59);
            if (bCalendar.before(eCalendar)) {
                timeSpanList.add((Pair<String, String>)Pair.of((Object)beginTime, (Object)DateUtil.formatTime(bCalendar.getTime(), format)));
                bCalendar.add(5, 1);
                bCalendar.set(11, 0);
                bCalendar.set(12, 0);
                bCalendar.set(13, 0);
                beginTime = DateUtil.formatTime(bCalendar.getTime(), format);
                continue;
            }
            timeSpanList.add((Pair<String, String>)Pair.of((Object)beginTime, (Object)endTime));
            break;
        }
        return timeSpanList;
    }
}

