/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES256EncryptionUtils {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] initkey() throws Exception {
        return new byte[]{8, 8, 4, 11, 2, 15, 11, 12, 1, 3, 9, 7, 12, 3, 7, 10, 4, 15, 6, 15, 14, 9, 5, 1, 10, 10, 1, 9, 6, 7, 9, 13};
    }

    private static Key toKey(byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }

    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        Key k = AES256EncryptionUtils.toKey(key);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM, "BC");
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        Key k = AES256EncryptionUtils.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(AES256EncryptionUtils.charToByte(hexChars[pos]) << 4 | AES256EncryptionUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static String bytes2HexString(byte[] b) {
        String ret = "";
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret = ret + hex.toUpperCase();
        }
        return ret;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String decryptAES256(String encryptedText, String secretKey) throws Exception {
        byte[] result = AES256EncryptionUtils.decrypt(AES256EncryptionUtils.hexStringToBytes(encryptedText.toUpperCase()), secretKey.getBytes());
        return new String(result);
    }

    public static String encryptAES256(String decryptedText, String secretKey) throws Exception {
        byte[] result = AES256EncryptionUtils.encrypt(decryptedText.getBytes(), secretKey.getBytes());
        return AES256EncryptionUtils.bytesToHexString(result).toUpperCase();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String key = "#o7pom!OT9$N1NrjU7QOca*z7fGRYzYj";
        String content = "cmcc2017";
        try {
            String pass = AES256EncryptionUtils.encryptAES256(content, key);
            System.out.println(pass);
            System.out.println(AES256EncryptionUtils.decryptAES256(pass.toUpperCase(), key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

