/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.view;

import com.allcam.common.system.log.MethodAspectHelper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ViewControllerAspectAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(ViewControllerAspectAdvice.class);

    @Pointcut(value="execution(public * com.allcam.*.view..*Controller.*(..))")
    public void viewControllerPointcut() {
    }

    @Around(value="viewControllerPointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        MethodAspectHelper helper = new MethodAspectHelper(pjp);
        helper.logEnter();
        Object result = pjp.proceed();
        helper.logLeave(null);
        return result;
    }
}

