/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.view;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.base.Result;
import com.allcam.common.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class JsonResult
implements Result {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CUSTOM_ERROR = "1001";
    private String resultCode;
    private String resultMessage;
    private String act = "reload";
    private String nextUrl;
    private AcBaseBean body;

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public String getAct() {
        return this.act;
    }

    public void setAct(String act) {
        this.act = act;
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public void setNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
    }

    public AcBaseBean getBody() {
        return this.body;
    }

    public void setBody(AcBaseBean body) {
        this.body = body;
    }

    @Override
    @JsonIgnore
    public boolean isSuccess() {
        return SUCCESS.equals(this.getResultCode());
    }

    @Override
    @JsonIgnore
    public int getError() {
        return StringUtil.toInt(this.resultCode, 2);
    }

    @Override
    @JsonIgnore
    public String requestResult() {
        return String.valueOf(this.resultCode).concat(":").concat(String.valueOf(this.resultMessage));
    }

    public JsonResult markSuccess() {
        this.setResultCode(SUCCESS);
        this.setResultMessage("\u64cd\u4f5c\u6210\u529f");
        return this;
    }

    public JsonResult markFailure() {
        return this.markFailure(CUSTOM_ERROR, "\u64cd\u4f5c\u5931\u8d25");
    }

    public JsonResult markFailure(String code, String message) {
        this.setResultCode(code);
        this.setResultMessage(message);
        return this;
    }
}

