/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TaskThreadPoolExecutor.class);
    private static final int SIZE = 4;
    private static final int MAX_SIZE = 8;
    private static final int MAX_COUNT = Integer.MAX_VALUE;
    private static final int TASK_TIMEOUT = 30;
    private ThreadPoolExecutor tpExecutor;

    public TaskThreadPoolExecutor() {
        this(4, 8, Integer.MAX_VALUE, 30);
    }

    public TaskThreadPoolExecutor(int size, int max, int count, int timeout) {
        this.tpExecutor = new ThreadPoolExecutor(size, max, (long)timeout, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(count), new MyExecutorPolicy());
    }

    public void putTask(Runnable task) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("put task to executor.");
        }
        try {
            this.tpExecutor.execute(task);
        }
        catch (Exception e) {
            LOG.error("putTask Fail: ", (Throwable)e);
        }
    }

    public static class MyExecutorPolicy
    implements RejectedExecutionHandler {
        MyExecutorPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            LOG.error("rejected execution.", (Object)e);
        }
    }
}

