/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrdinaryTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(OrdinaryTaskManager.class);
    private List<OrdinaryTask> delayTasks;
    private final BlockingQueue<OrdinaryTask> taskQueue = new LinkedBlockingQueue<OrdinaryTask>();

    public void putTask(OrdinaryTask task) {
        if (null != task) {
            this.taskQueue.add(task);
        }
    }

    public void removeTask(OrdinaryTask task) {
        if (null != task) {
            if (null != this.delayTasks) {
                this.delayTasks.remove(task);
            }
            this.taskQueue.remove(task);
        }
    }

    public void removeTask(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        if (null != this.delayTasks) {
            this.delayTasks.removeIf(task -> taskId.equals(task.getTaskId()));
        }
        this.taskQueue.removeIf(task -> taskId.equals(task.getTaskId()));
    }

    void onCheck() {
        OrdinaryTask task;
        this.delayTasks = Collections.synchronizedList(new ArrayList());
        while (null != (task = (OrdinaryTask)this.taskQueue.poll())) {
            if (task.canExecute()) {
                LOG.info("start run task --> taskId=[{}]", (Object)task.getTaskId());
                try {
                    task.run();
                }
                catch (Exception e) {
                    if (task.retryOnException()) {
                        LOG.error("task[{}] retry on exception[{}]", (Object)task.getTaskId(), (Object)e.getMessage());
                        this.delayTasks.add(task);
                        continue;
                    }
                    LOG.error("task run with exception.", (Throwable)e);
                }
                continue;
            }
            LOG.info("task cannot execute now --> taskId=[{}]", (Object)task.getTaskId());
            this.delayTasks.add(task);
        }
        if (!this.delayTasks.isEmpty()) {
            this.taskQueue.addAll(this.delayTasks);
        }
        this.delayTasks = null;
    }

    public static interface OrdinaryTask
    extends Runnable {
        public String getTaskId();

        public boolean canExecute();

        public boolean retryOnException();
    }
}

