/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import com.allcam.common.system.task.TaskThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntervalTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(IntervalTaskManager.class);
    private final List<IntervalTask> taskList = Collections.synchronizedList(new ArrayList());
    @Resource
    private TaskThreadPoolExecutor taskThreadPoolExecutor;

    public String post(Runnable runnable, int interval) {
        return this.post(runnable, interval, 0);
    }

    public String postDelay(Runnable runnable, int delay) {
        return this.post(runnable, 0, delay, 1);
    }

    public String post(Runnable runnable, int interval, int delay) {
        return this.post(runnable, interval, delay, 0);
    }

    public String post(Runnable runnable, int interval, int delay, int times) {
        if (null == runnable) {
            LOG.error("runnable is null.");
            return null;
        }
        IntervalTask task = new IntervalTask(runnable, interval, delay, times);
        this.taskList.add(task);
        LOG.info("post task success, task={}", (Object)task);
        return task.taskId;
    }

    public void remove(Runnable runnable) {
        if (null != runnable) {
            this.taskList.removeIf(task -> task.runnable == runnable);
        }
    }

    public void remove(String taskId) {
        if (!StringUtils.isEmpty((CharSequence)taskId)) {
            this.taskList.removeIf(task -> taskId.equals(task.taskId));
        }
    }

    void onCheck() {
        if (this.taskList.isEmpty()) {
            return;
        }
        LOG.info("there are [{}] interval tasks to execute", (Object)this.taskList.size());
        ArrayList<IntervalTask> task2Remove = new ArrayList<IntervalTask>();
        ArrayList<IntervalTask> exeTasks = new ArrayList<IntervalTask>(this.taskList);
        for (IntervalTask task : exeTasks) {
            if (!task.canExecute()) continue;
            task.executeTask();
            if (!task.shouldDestroy()) continue;
            task2Remove.add(task);
        }
        this.taskList.removeAll(task2Remove);
    }

    private class IntervalTask {
        final String taskId;
        final int interval;
        final int exeDelay;
        final int loopTimes;
        final Runnable runnable;
        int runTimes = 0;
        long nextRunTime;

        IntervalTask(Runnable task, int interval, int exeDelay, int loopTimes) {
            Random random = new Random();
            int rInt = random.nextInt(100000);
            this.taskId = String.valueOf(System.currentTimeMillis()).concat(String.valueOf(rInt));
            this.interval = interval * 1000;
            this.exeDelay = exeDelay * 1000;
            this.loopTimes = loopTimes;
            this.runnable = task;
            this.nextRunTime = System.currentTimeMillis() + (long)this.exeDelay;
        }

        boolean canExecute() {
            return this.nextRunTime <= System.currentTimeMillis();
        }

        boolean shouldDestroy() {
            return this.loopTimes > 0 && this.runTimes >= this.loopTimes;
        }

        void executeTask() {
            this.nextRunTime += (long)this.interval;
            try {
                IntervalTaskManager.this.taskThreadPoolExecutor.putTask(this.runnable);
            }
            catch (Exception e) {
                LOG.error("executeTask fail on method[run]", (Throwable)e);
            }
            ++this.runTimes;
        }

        public String toString() {
            return "[taskId:" + this.taskId + ",interval:" + this.interval + ",exeDelay:" + this.exeDelay + ",loopTimes:" + this.loopTimes + "]";
        }
    }
}

