/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import com.allcam.common.system.context.SpringContextHolder;
import com.allcam.common.utils.DateUtil;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public final class DistributedTimedTaskQueue {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedTimedTaskQueue.class);
    private static final String KEY_TASK_QUEUE = ":task_q";
    private static final String KEY_TASK_QUEUE_DONE = ":task_d:";
    private String namespace;
    private StringRedisTemplate stringRedisTemplate;

    private DistributedTimedTaskQueue(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace must has text.");
        this.namespace = namespace;
        this.stringRedisTemplate = SpringContextHolder.getBean(StringRedisTemplate.class);
    }

    public void pushTask(String taskId) {
        String key = this.generateKey();
        this.stringRedisTemplate.boundListOps((Object)key).rightPush((Object)taskId);
        LOG.info("pushKeepAliveTask [key:{}, value:{}] success.", (Object)key, (Object)taskId);
    }

    public void removeTask(String taskId) {
        String key = this.generateKey();
        this.stringRedisTemplate.boundListOps((Object)key).remove(0L, (Object)taskId);
        LOG.info("removeKeepAliveTask [key:{}, value:{}] success.", (Object)key, (Object)taskId);
    }

    private String loopPullTask() {
        String key = this.generateKey();
        return (String)this.stringRedisTemplate.opsForList().rightPopAndLeftPush((Object)key, (Object)key);
    }

    private void onTaskDone(String taskId, String sequence) {
        String key = this.generateKey(true) + sequence;
        BoundSetOperations setOper = this.stringRedisTemplate.boundSetOps((Object)key);
        setOper.add((Object[])new String[]{taskId});
        setOper.expire(1L, TimeUnit.MINUTES);
    }

    private boolean isTaskDone(String taskId, String sequence) {
        String key = this.generateKey(true) + sequence;
        Boolean result = this.stringRedisTemplate.opsForSet().isMember((Object)key, (Object)taskId);
        return null == result ? false : result;
    }

    private String generateKey() {
        return this.generateKey(false);
    }

    private String generateKey(boolean done) {
        return this.namespace + (done ? KEY_TASK_QUEUE_DONE : KEY_TASK_QUEUE);
    }

    public static void triggerTasks(String namespace, TaskTrigger trigger) {
        try {
            String exeTime = DateUtil.nowYmdHms();
            DistributedTimedTaskQueue taskQueue = new DistributedTimedTaskQueue(namespace);
            while (true) {
                String taskId;
                if (StringUtils.isBlank((CharSequence)(taskId = taskQueue.loopPullTask()))) {
                    LOG.info("trigger tasks Finish, task not exist.");
                    break;
                }
                if (taskQueue.isTaskDone(taskId, exeTime)) {
                    LOG.info("trigger tasks Finish, task handle finish.");
                    break;
                }
                try {
                    trigger.onExecute(taskId);
                }
                catch (Exception e) {
                    LOG.error("trigger task execute fail.", (Throwable)e);
                }
                taskQueue.onTaskDone(taskId, exeTime);
            }
        }
        catch (Exception e) {
            LOG.error("trigger tasks fail.", (Throwable)e);
        }
    }

    public static interface TaskTrigger {
        public void onExecute(String var1);
    }
}

