/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import com.allcam.common.system.task.IntervalTaskManager;
import com.allcam.common.system.task.OrdinaryTaskManager;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
public class CommonTaskEngine
implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(CommonTaskEngine.class);
    @Resource
    private OrdinaryTaskManager ordinaryTaskManager;
    @Resource
    private IntervalTaskManager intervalTaskManager;

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("schedule-thread-%d").daemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());
        scheduledTaskRegistrar.setScheduler((Object)executorService);
    }

    @Scheduled(fixedRate=1000L)
    public void ordinaryTaskEngine() {
        try {
            this.ordinaryTaskManager.onCheck();
        }
        catch (Exception e) {
            LOG.error("check ordinary task failed: ", (Throwable)e);
        }
    }

    @Scheduled(fixedRate=1000L)
    public void intervalTaskEngine() {
        try {
            this.intervalTaskManager.onCheck();
        }
        catch (Exception e) {
            LOG.error("check interval task failed: ", (Throwable)e);
        }
    }
}

