/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import com.allcam.common.system.context.SpringContextHolder;
import com.allcam.common.utils.DateUtil;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class ClusterTaskLocker {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterTaskLocker.class);

    public static boolean tryLock(String name, String message, long timeout) {
        StringRedisTemplate rt = SpringContextHolder.getBean(StringRedisTemplate.class);
        Assert.notNull((Object)rt, (String)"redis template not found in context.");
        Assert.hasText((String)name, (String)"name is empty.");
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"timeout seconds must be positive.");
        if (StringUtils.isBlank((CharSequence)message)) {
            message = DateUtil.now("yyyy-MM-dd HH:mm:ss");
        }
        return ClusterTaskLocker.setNX((RedisTemplate<String, String>)rt, name, message, timeout);
    }

    public static boolean checkTaskCanExecute(RedisTemplate<String, String> rt, String taskId, long expireSecs) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            LOG.error("taskType is blank.");
            return false;
        }
        if (expireSecs <= 0L) {
            LOG.error("expireSecs is less than 0.");
            return false;
        }
        String taskStamp = DateUtil.now("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isBlank((CharSequence)taskStamp)) {
            LOG.error("taskStamp is blank.");
            return false;
        }
        return ClusterTaskLocker.setNX(rt, taskId, taskStamp, expireSecs);
    }

    private static boolean setNX(RedisTemplate<String, String> rt, String key, String value, long expireSecs) {
        boolean success;
        Boolean result = (Boolean)rt.execute(redisConnection -> {
            byte[] keys = rt.getStringSerializer().serialize((Object)key);
            byte[] values = rt.getStringSerializer().serialize((Object)value);
            return redisConnection.setNX(keys, values);
        });
        boolean bl = success = null != result && result != false;
        if (success) {
            rt.expire((Object)key, expireSecs, TimeUnit.SECONDS);
        }
        return success;
    }
}

