/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.task;

import com.allcam.common.system.context.SpringContextHolder;
import com.allcam.common.system.task.ClusterTaskLocker;
import com.allcam.common.system.task.IntervalTaskManager;
import com.allcam.common.utils.GenerateUtil;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class ClusterMutexTaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterMutexTaskExecutor.class);
    private static final String CLUSTER_ID = GenerateUtil.generateId();
    private StringRedisTemplate stringRedisTemplate;
    private IntervalTaskManager intervalTaskManager;
    private int lockCheckInterval;
    private int lockExpire;
    private boolean locked = false;
    private final Task task;
    private final String lockId;
    private final Runnable keepaliveRun = this::lockKeepalive;
    private Thread shutdownHook;

    public static void mutexLock(String lockId, int interval, Runnable runnable) {
        Assert.hasText((String)lockId, (String)"lockId is empty.");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval illegal.");
        Assert.notNull((Object)runnable, (String)"runnable is null.");
        ClusterMutexTaskExecutor.mutexLock(new IntervalTask(lockId, interval, runnable));
    }

    public static ClusterMutexTaskExecutor mutexLock(Task task) {
        return ClusterMutexTaskExecutor.mutexLock(task, 30, 3);
    }

    public static ClusterMutexTaskExecutor mutexLock(Task task, int interval, int expTimes) {
        Assert.notNull((Object)task, (String)"task is null.");
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval must be positive.");
        Assert.isTrue((expTimes > 0 ? 1 : 0) != 0, (String)"expire times must be positive.");
        ClusterMutexTaskExecutor executor = new ClusterMutexTaskExecutor(task);
        executor.interval(interval, expTimes);
        executor.lock();
        return executor;
    }

    private ClusterMutexTaskExecutor(Task task) {
        this.task = task;
        this.lockId = task.lockId();
        this.stringRedisTemplate = SpringContextHolder.getBean(StringRedisTemplate.class);
        this.intervalTaskManager = SpringContextHolder.getBean(IntervalTaskManager.class);
    }

    public void release() {
        LOG.info("cluster lock release.");
        this.stringRedisTemplate.delete((Object)this.lockId);
        if (this.locked) {
            this.intervalTaskManager.remove(this.keepaliveRun);
            this.locked = false;
        }
    }

    private void interval(int seconds, int expTimes) {
        this.lockCheckInterval = seconds;
        this.lockExpire = seconds * expTimes;
    }

    private void lock() {
        try {
            boolean lockDone = ClusterTaskLocker.tryLock(this.lockId, CLUSTER_ID, this.lockExpire);
            if (lockDone) {
                LOG.debug("cluster task lock done, callback for task to run.");
                try {
                    this.task.onLocked();
                    this.lockSuccess();
                }
                catch (Exception e) {
                    LOG.error("cluster task run fail, release lock.");
                    this.stringRedisTemplate.delete((Object)this.lockId);
                    this.lockFailure();
                }
            } else {
                LOG.info("cluster task lock by other.");
                this.lockFailure();
            }
        }
        catch (Exception e) {
            LOG.error("cluster task lock with exception.", (Throwable)e);
            this.lockFailure();
        }
    }

    private void lockSuccess() {
        LOG.info("cluster task lock success, keep lock per {}s.", (Object)this.lockCheckInterval);
        this.locked = true;
        this.intervalTaskManager.post(this.keepaliveRun, this.lockCheckInterval, this.lockCheckInterval);
        if (null == this.shutdownHook) {
            this.shutdownHook = new Thread(this::onApplicationStopping);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    private void lockKeepalive() {
        LOG.info("cluster task lock keepalive.");
        try {
            String clusterId = (String)this.stringRedisTemplate.opsForValue().get((Object)this.lockId);
            if (StringUtils.equals((CharSequence)clusterId, (CharSequence)CLUSTER_ID)) {
                this.stringRedisTemplate.expire((Object)this.lockId, (long)this.lockExpire, TimeUnit.SECONDS);
            } else {
                LOG.warn("keepalive break, maybe other cluster scrambled for the lock.");
                this.lockFailure();
            }
        }
        catch (Exception e) {
            LOG.error("cluster task lock keepalive run with exception.", (Throwable)e);
        }
    }

    private void lockFailure() {
        LOG.info("cluster lock fail, scramble for lock after {}s.", (Object)this.lockCheckInterval);
        this.locked = false;
        this.intervalTaskManager.remove(this.keepaliveRun);
        this.intervalTaskManager.postDelay(this::lock, this.lockCheckInterval);
        try {
            this.task.onLockFail();
        }
        catch (Exception e) {
            LOG.error("callback for task on lock fail run with exception.", (Throwable)e);
        }
    }

    private void onApplicationStopping() {
        LOG.debug("application stopping, cluster task lock release if locked.");
        if (this.locked) {
            this.stringRedisTemplate.delete((Object)this.lockId);
        }
    }

    public static interface Task {
        public String lockId();

        public void onLocked();

        public void onLockFail();
    }

    private static class IntervalTask
    implements Task {
        private final String lockId;
        private final int interval;
        private final Runnable runnable;
        private IntervalTaskManager intervalTaskManager;

        IntervalTask(String lockId, int interval, Runnable runnable) {
            this.lockId = lockId;
            this.interval = interval;
            this.runnable = runnable;
        }

        private IntervalTaskManager getIntervalTaskManager() {
            if (null == this.intervalTaskManager) {
                this.intervalTaskManager = SpringContextHolder.getBean(IntervalTaskManager.class);
            }
            return this.intervalTaskManager;
        }

        @Override
        public String lockId() {
            return this.lockId;
        }

        @Override
        public void onLocked() {
            this.getIntervalTaskManager().remove(this.runnable);
            this.getIntervalTaskManager().post(this.runnable, this.interval);
        }

        @Override
        public void onLockFail() {
            this.getIntervalTaskManager().remove(this.runnable);
        }
    }
}

