/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.log;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.base.BaseRequest;
import com.allcam.common.base.BaseResponse;
import com.allcam.common.base.Response;
import com.allcam.common.system.context.SpringContextHolder;
import com.allcam.common.system.log.LogExecution;
import com.allcam.common.system.log.OperateLogger;
import com.allcam.common.system.task.TaskThreadPoolExecutor;
import com.allcam.common.utils.JSONUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodAspectHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodAspectHelper.class);
    private ProceedingJoinPoint joinPoint;
    private MethodSignature signature;
    private String methodFullName;
    private Class<?>[] paramTypes;
    private Object[] params;
    private Object param;

    public MethodAspectHelper(ProceedingJoinPoint pjp) {
        this.joinPoint = pjp;
        this.signature = (MethodSignature)pjp.getSignature();
        String methodName = this.signature.getName();
        String className = pjp.getTarget().getClass().getName();
        this.methodFullName = className + "." + methodName;
        this.paramTypes = this.signature.getParameterTypes();
        this.params = pjp.getArgs();
        if (null != this.params && this.params.length > 0) {
            this.param = this.params[0];
        }
    }

    public <T> T getFirstParam() {
        return (T)this.param;
    }

    public <T extends Annotation> T getMethodAnnotation(Class<T> annotationClass) {
        return this.signature.getMethod().getAnnotation(annotationClass);
    }

    private Class getReturnType() {
        return this.signature.getMethod().getReturnType();
    }

    private Object getReturnObject() {
        Object retObject = null;
        try {
            Class retClass = this.getReturnType();
            retObject = retClass.newInstance();
        }
        catch (Exception e) {
            LOG.warn("getReturnObject class newInstance fail.", (Object)e.getMessage());
        }
        return retObject;
    }

    public Object getMethodResponse(int errorCode, Throwable e) throws Throwable {
        Object retObject = this.getReturnObject();
        if (!(retObject instanceof Response)) {
            throw e;
        }
        Response response = (Response)retObject;
        response.setResultCode(errorCode);
        response.setResultDesc(e.getMessage());
        return retObject;
    }

    public void logEnter() {
        if (LOG.isInfoEnabled()) {
            LOG.info(">>> Enter " + this.methodFullName);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Parameters:[");
            if (null != this.params && this.params.length > 0) {
                for (int i = 0; i < this.params.length; ++i) {
                    Object arg = this.params[i];
                    builder.append(arg);
                    if (i >= this.params.length - 1) continue;
                    builder.append(", ");
                }
            }
            builder.append("]");
            LOG.debug(builder.toString());
        }
    }

    public void logLeave(Object returnValue) {
        if (LOG.isDebugEnabled()) {
            if (returnValue instanceof AcBaseBean) {
                LOG.debug("Return:[{}]", returnValue);
            } else if (returnValue instanceof Serializable) {
                LOG.debug("Return:[{}]", (Object)JSONUtil.log(returnValue));
            } else {
                LOG.debug("Return:[{}]", returnValue);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("<<< Exit " + this.methodFullName);
        }
    }

    public void logError(Throwable e) {
        LOG.error(this.methodFullName + " occur error: ", e);
    }

    /*
     * Exception decompiling
     */
    public Object logExecute() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void recordLog(Object returnObj) {
        try {
            if (null == this.params || this.params.length != 1) {
                LOG.debug("method not request response mode, cannot record log.");
                return;
            }
            if (!(this.param instanceof BaseRequest) || !(returnObj instanceof BaseResponse)) {
                LOG.debug("method not request response mode, cannot record log.");
                return;
            }
            LogExecution le = this.getMethodAnnotation(LogExecution.class);
            if (null == le || !le.record()) {
                LOG.debug("method log record closed.");
                return;
            }
            String type = le.value();
            if (StringUtils.isBlank((CharSequence)type)) {
                LOG.debug("method log record value not set.");
                return;
            }
            BaseRequest request = (BaseRequest)this.getFirstParam();
            if (null == request.getAccessInfo()) {
                LOG.debug("service call by internal, should not record log.");
                return;
            }
            OperateLogger logger = SpringContextHolder.getBean(OperateLogger.class);
            if (null == logger) {
                LOG.debug("method log record OperateLogger not implement.");
                return;
            }
            BaseResponse response = (BaseResponse)returnObj;
            TaskThreadPoolExecutor threadPool = SpringContextHolder.getBean(TaskThreadPoolExecutor.class);
            threadPool.putTask(() -> logger.log(type, request, response));
            LOG.debug("method log record put to task pool.");
        }
        catch (Exception e) {
            LOG.error("method log record execute fail.", (Throwable)e);
        }
    }
}

