/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.http;

import com.allcam.common.system.http.HttpRequestException;
import com.allcam.common.utils.JSONUtil;
import com.allcam.common.utils.ServletUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AcHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(AcHttpClient.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType XML = MediaType.parse((String)"application/xml; charset=utf-8");

    protected abstract OkHttpClient getHttpClient();

    public <T> T postJson4Object(String url, String json, Class<T> retClass) throws IOException, HttpRequestException {
        String retStr = this.postJson(url, json);
        if (StringUtils.isEmpty((CharSequence)retStr)) {
            return null;
        }
        return JSONUtil.fromJson(retStr, retClass);
    }

    public String postJson(String url, String json) throws IOException, HttpRequestException {
        return this.post(url, json, JSON);
    }

    public String postXml(String url, String xml) throws IOException, HttpRequestException {
        return this.post(url, xml, XML);
    }

    public String post(String url, String body, MediaType type) throws IOException, HttpRequestException {
        LOG.debug("Http(url,body,type) SYNC post: \n url=[{}] \n body=[{}]", (Object)url, (Object)body);
        RequestBody reqBody = RequestBody.create((MediaType)type, (String)body);
        Request request = new Request.Builder().url(url).post(reqBody).build();
        return this.exeHttp(request);
    }

    public <T> T post4Json(String url, Map<String, String> params, Map<String, String> headers, Class<T> retClass) throws IOException, HttpRequestException {
        String retStr = this.post(url, params, headers);
        if (StringUtils.isEmpty((CharSequence)retStr)) {
            return null;
        }
        return JSONUtil.fromJson(retStr, retClass);
    }

    public String post(String url, Map<String, String> params, Map<String, String> headers) throws IOException, HttpRequestException {
        url = ServletUtil.buildUrlWithParams(url, params);
        Request.Builder reqBuilder = new Request.Builder();
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)reqBuilder).addHeader(arg_0, arg_1));
        }
        RequestBody reqBody = RequestBody.create(null, (String)"");
        LOG.debug("Http(host,port,params,headers) SYNC post: \n url=[{}] \n body=[{}]", (Object)url, (Object)reqBody);
        return this.exeHttp(reqBuilder.url(url).post(reqBody).build());
    }

    public String postForm(String url, Map<String, String> formMap, Map<String, String> headers) throws IOException, HttpRequestException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (!CollectionUtils.isEmpty(formMap)) {
            formMap.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).add(arg_0, arg_1));
        }
        FormBody formBody = formBodyBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return this.exeHttp(requestBuilder.post((RequestBody)formBody).url(url).build());
    }

    public String postFormEncoded(String url, Map<String, String> formMap, Map<String, String> headers, boolean alreadyEncoded) throws IOException, HttpRequestException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (!CollectionUtils.isEmpty(formMap)) {
            formMap.forEach(alreadyEncoded ? (arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).addEncoded(arg_0, arg_1) : (arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).add(arg_0, arg_1));
        }
        FormBody formBody = formBodyBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return this.exeHttp(requestBuilder.post((RequestBody)formBody).url(url).build());
    }

    public String postJson(String url, Map<String, String> headers, String json) throws IOException, HttpRequestException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder requestBuilder = new Request.Builder();
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return this.exeHttp(requestBuilder.post(body).url(url).build());
    }

    public String get(String url) throws IOException, HttpRequestException {
        LOG.debug("Http(url) SYNC get: \n url=[{}] ", (Object)url);
        return this.exeHttp(new Request.Builder().url(url).addHeader("Connection", "close").get().build());
    }

    private String exeHttp(Request request) throws IOException, HttpRequestException {
        try (Response response = this.getHttpClient().newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new HttpRequestException(response.code());
            }
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                LOG.warn("response success, but response body is empty.");
                String string = null;
                return string;
            }
            String bodyString = responseBody.string();
            LOG.debug("Http Response body:\n {}", (Object)bodyString);
            String string = bodyString;
            return string;
        }
    }

    public void asyncPostJson(String url, String json, Callback callback) {
        this.asyncPost(url, JSON, json, callback);
    }

    public void asyncPostXml(String url, String xml, Callback callback) {
        this.asyncPost(url, XML, xml, callback);
    }

    public void asyncPost(String url, MediaType type, String body, Callback callback) {
        LOG.debug("Http(url,type,body,callback) ASYNC post: \n url=[{}] \n body=[{}]", (Object)url, (Object)body);
        RequestBody reqBody = RequestBody.create((MediaType)type, (String)body);
        Request request = new Request.Builder().url(url).post(reqBody).build();
        if (null == callback) {
            callback = new Callback(){

                public void onFailure(Call call, IOException e) {
                    LOG.debug("default callback: onFailure()");
                }

                public void onResponse(Call call, Response response) {
                    LOG.debug("default callback: onResponse()");
                    if (null != response) {
                        response.close();
                    }
                }
            };
        }
        this.getHttpClient().newCall(request).enqueue(callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] download(String url) {
        LOG.debug("AcHttpClient", (Object)"down from url:[{}]", (Object)url);
        Request request = new Request.Builder().url(url).addHeader("Connection", "close").build();
        try (Response response = this.getHttpClient().newCall(request).execute();){
            ResponseBody body = response.body();
            if (null == body) {
                byte[] byArray2 = null;
                return byArray2;
            }
            if (!response.isSuccessful()) {
                throw new IllegalStateException("download file error code: " + response);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = body.byteStream();){
                IOUtils.copy((InputStream)is, (OutputStream)baos, (int)1024);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOG.error("download file fail.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int downloadFile(String url, String filePath) {
        LOG.debug("AcHttpClient", new Object[]{"downFile from [{}] to [{}]", url, filePath});
        Request request = new Request.Builder().url(url).addHeader("Connection", "close").build();
        try (Response response = this.getHttpClient().newCall(request).execute();){
            ResponseBody body = response.body();
            if (null == body) {
                int n2 = 1;
                return n2;
            }
            if (!response.isSuccessful()) {
                throw new IllegalStateException("download file error code: " + response);
            }
            File file = new File(filePath);
            try (InputStream is = body.byteStream();
                 FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)is, (OutputStream)fos, (int)4096);
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.error("download file fail.", (Throwable)e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int uploadFile(String url, File file, String fileName, String mediaType, Map<String, String> partMap) {
        Assert.hasText((String)url, (String)"url is empty");
        Assert.notNull((Object)file, (String)"file is null");
        Assert.hasText((String)fileName, (String)"file name is empty");
        Assert.hasText((String)mediaType, (String)"media type is empty");
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)mediaType), (File)file);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody);
        if (null != partMap && !partMap.isEmpty()) {
            partMap.forEach((arg_0, arg_1) -> ((MultipartBody.Builder)bodyBuilder).addFormDataPart(arg_0, arg_1));
        }
        Request request = new Request.Builder().url(url).post((RequestBody)bodyBuilder.build()).build();
        try (Response response = this.getHttpClient().newCall(request).execute();){
            ResponseBody body = response.body();
            if (null == body) {
                int n2 = 1;
                return n2;
            }
            if (!response.isSuccessful()) {
                throw new IllegalStateException("upload file error code: " + response);
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.error("upload file fail.", (Throwable)e);
            return -1;
        }
    }
}

