/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(StreamGobbler.class);
    private InputStream inputStream;
    private String streamType;
    private StringBuilder buf;
    private volatile boolean isStopped = false;

    public StreamGobbler(InputStream inputStream, String streamType) {
        this.inputStream = inputStream;
        this.streamType = streamType;
        this.buf = new StringBuilder();
        this.isStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                this.buf.append(line).append("\n");
            }
        }
        catch (IOException ex) {
            logger.trace("Failed to successfully consume and display the input stream of type " + this.streamType + ".", (Throwable)ex);
        }
        finally {
            this.isStopped = true;
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() {
        if (!this.isStopped) {
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    ignore.printStackTrace();
                }
            }
        }
        return this.buf.toString();
    }
}

