/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.exception;

import com.allcam.common.system.exception.BusinessException;
import java.util.Collection;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AcsAssert {
    public static void isTrue(boolean expression, int errorCode) {
        if (!expression) {
            throw new BusinessException(errorCode);
        }
    }

    public static void isNull(@Nullable Object object, int errorCode) {
        if (object != null) {
            throw new BusinessException(errorCode);
        }
    }

    public static void notNull(@Nullable Object object, int errorCode) {
        if (object == null) {
            throw new BusinessException(errorCode);
        }
    }

    public static void hasLength(@Nullable String text, int errorCode) {
        if (!StringUtils.hasLength((String)text)) {
            throw new BusinessException(errorCode);
        }
    }

    public static void hasText(@Nullable String text, int errorCode) {
        if (!StringUtils.hasText((String)text)) {
            throw new BusinessException(errorCode);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, int errorCode) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.contains(substring)) {
            throw new BusinessException(errorCode);
        }
    }

    public static void notEmpty(@Nullable Object[] array, int errorCode) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw new BusinessException(errorCode);
        }
    }

    public static void noNullElements(@Nullable Object[] array, int errorCode) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new BusinessException(errorCode);
            }
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, int errorCode) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessException(errorCode);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, int errorCode) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BusinessException(errorCode);
        }
    }
}

