/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.system.context;

import com.alibaba.dubbo.config.spring.ReferenceBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpringContextHolder
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext = null;
    private static Map<String, Object> dubboServiceCache = new ConcurrentHashMap<String, Object>();

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static String getProperty(String key) {
        SpringContextHolder.assertContextInjected();
        return applicationContext.getEnvironment().getProperty(key);
    }

    public static String getProperty(String key, String defValue) {
        SpringContextHolder.assertContextInjected();
        return applicationContext.getEnvironment().getProperty(key, defValue);
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T getDubboService(Class<T> serviceClass) {
        return SpringContextHolder.getDubboService(serviceClass, null);
    }

    public static <T> T getDubboService(Class<T> serviceClass, String group) {
        return SpringContextHolder.getDubboService(serviceClass, group, null, 0);
    }

    public static <T> T getDubboService(Class<T> serviceClass, String ip, int port) {
        if (StringUtils.isBlank((CharSequence)ip) || 0 == port) {
            return null;
        }
        return SpringContextHolder.getDubboService(serviceClass, null, ip, port);
    }

    public static <T> T getDubboService(Class<T> serviceClass, String group, String ip, int port) {
        LOG.debug("getDubboService serviceClass={}, group={}, ip={}, port={}", new Object[]{serviceClass, group, ip, port});
        String cacheKey = serviceClass.getName() + group + ip + port;
        LOG.debug("getDubboService generate cacheKey={}", (Object)cacheKey);
        Object service = dubboServiceCache.computeIfAbsent(cacheKey, k -> {
            LOG.debug("dubbo service not exist, ready to get one.");
            ReferenceBean referenceBean = new ReferenceBean();
            referenceBean.setApplicationContext(applicationContext);
            referenceBean.setInterface(serviceClass);
            if (StringUtils.isNotBlank((CharSequence)group)) {
                referenceBean.setGroup(group);
            }
            if (StringUtils.isNotBlank((CharSequence)ip) && port > 0) {
                referenceBean.setUrl("dubbo://" + ip + ":" + port);
            }
            try {
                referenceBean.afterPropertiesSet();
                Object dubboService = referenceBean.get();
                if (null == dubboService) {
                    LOG.error("getDubboService return null.");
                    referenceBean.destroy();
                    return null;
                }
                LOG.debug("getDubboService dubboService={}", dubboService);
                return dubboService;
            }
            catch (Exception e) {
                LOG.error("getDubboService fail.", (Throwable)e);
                referenceBean.destroy();
                return null;
            }
        });
        Assert.state((service != null ? 1 : 0) != 0, (String)"\u83b7\u53d6DUBBO\u670d\u52a1\u5931\u8d25");
        return (T)service;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    private static void assertContextInjected() {
        Assert.notNull((Object)applicationContext, (String)"applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.");
    }
}

