/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.model;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class PageInfo
extends AcBaseBean {
    private static final long serialVersionUID = 7965614195557978358L;
    public static final int DEFAULT_PAGE_SIZE = 50;
    @Verification(type=VerifyType.BETWEEN, param="1,")
    private int pageNum;
    @Verification(type=VerifyType.BETWEEN, param="0,5000")
    private int pageSize;
    private long totalNum;

    public static PageInfo getDefault() {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(1);
        pageInfo.setPageSize(50);
        return pageInfo;
    }

    @JsonIgnore
    public boolean isFirst() {
        return this.pageNum == 1;
    }

    @JsonIgnore
    public boolean isLast() {
        return this.pageNum == this.getTotalPage();
    }

    @JsonIgnore
    public void previous() {
        if (this.isFirst()) {
            return;
        }
        --this.pageNum;
    }

    @JsonIgnore
    public void next() {
        if (this.isLast()) {
            return;
        }
        ++this.pageNum;
    }

    @JsonIgnore
    public int getTotalPage() {
        int totalPage = (int)(this.totalNum / (long)this.pageSize);
        if (0L != this.totalNum % (long)this.pageSize) {
            ++totalPage;
        }
        return totalPage;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public long getTotalNum() {
        return this.totalNum;
    }

    public void setTotalNum(long totalNum) {
        this.totalNum = totalNum;
    }

    public int getPageSize() {
        if (this.pageSize == 0) {
            return 50;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

