/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.base;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.base.AccessInfo;
import com.allcam.common.utils.ServletUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseRequest
extends AcBaseBean {
    private static final long serialVersionUID = 3324749809979170529L;
    private String pkgAccount;
    private String appID;
    private String sign;
    private String msgtimestamp;
    private int cuType;
    private String sessionId;
    private AccessInfo accessInfo;

    public String getAccessDeviceId() {
        return null;
    }

    public void checkAccess() {
        Assert.notNull((Object)this.accessInfo, (String)"api call without access.");
        Assert.hasText((String)this.accessInfo.getAutherId(), (String)"api call without auth.");
    }

    @JsonIgnore
    public <T extends BaseRequest> T from(HttpServletRequest servletRequest) {
        if (null != servletRequest) {
            if (null == this.accessInfo) {
                this.accessInfo = new AccessInfo(servletRequest);
            } else {
                this.accessInfo.setAccessIp(ServletUtil.getRequestIPAddress(servletRequest));
                this.accessInfo.setUserAgent(servletRequest.getHeader("User-Agent"));
            }
        }
        return (T)this;
    }

    @JsonIgnore
    public <T extends BaseRequest> T forUser(String userId) {
        if (null == this.accessInfo) {
            this.accessInfo = new AccessInfo();
        }
        this.accessInfo.setAutherId(userId);
        this.accessInfo.setAuthType(AccessInfo.Type.AUTH_USER);
        return (T)this;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getPkgAccount() {
        return this.pkgAccount;
    }

    public void setPkgAccount(String pkgAccount) {
        this.pkgAccount = pkgAccount;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getMsgtimestamp() {
        return this.msgtimestamp;
    }

    public void setMsgtimestamp(String msgtimestamp) {
        this.msgtimestamp = msgtimestamp;
    }

    public int getCuType() {
        return this.cuType;
    }

    public void setCuType(int cuType) {
        this.cuType = cuType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public AccessInfo getAccessInfo() {
        return this.accessInfo;
    }

    public void setAccessInfo(AccessInfo accessInfo) {
        this.accessInfo = accessInfo;
    }
}

