/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.base;

import com.allcam.common.utils.JSONUtil;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AcBaseBean
implements Serializable {
    private static final long serialVersionUID = -1988747767873934391L;
    private static final Logger LOG = LoggerFactory.getLogger(AcBaseBean.class);

    public <T> T transTo(Class<T> dstClass) {
        if (this.getClass().equals(dstClass)) {
            return (T)this;
        }
        try {
            T dstBean = dstClass.newInstance();
            BeanUtils.copyProperties((Object)this, dstBean);
            return dstBean;
        }
        catch (Exception e) {
            LOG.error("transTo fail: ", (Throwable)e);
            return null;
        }
    }

    public void mergeFrom(Object source) {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Class<?> actualEditable = this.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null) continue;
            try {
                Method readMethod;
                PropertyDescriptor sourcePd;
                Object thisValue;
                Method thisReadMethod = targetPd.getReadMethod();
                if (!Modifier.isPublic(thisReadMethod.getDeclaringClass().getModifiers())) {
                    thisReadMethod.setAccessible(true);
                }
                if ((thisValue = thisReadMethod.invoke((Object)this, new Object[0])) != null && (!(thisValue instanceof Number) || ((Number)thisValue).intValue() != 0) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke((Object)this, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public String toString() {
        return JSONUtil.makeLog(this);
    }
}

