/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class Lexer {
    private final String text;
    protected int pos;
    protected int mark;
    protected char ch;
    protected char[] buf;
    protected int bufPos;
    protected Token token;
    protected Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    protected String stringVal;
    protected boolean skipComment = true;
    private SavePoint savePoint = null;
    private boolean allowComment = true;
    private int varIndex = -1;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public Lexer(String input) {
        this(input, true);
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public String addSymbol() {
        return this.subString(this.mark, this.bufPos);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    protected void initBuff(int size) {
        if (this.buf == null) {
            this.buf = size < 32 ? new char[32] : new char[size + 32];
        } else if (this.buf.length < size) {
            this.buf = Arrays.copyOf(this.buf, size);
        }
    }

    public void arraycopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public int nextVarIndex() {
        return ++this.varIndex;
    }

    public Keywords getKeywods() {
        return this.keywods;
    }

    public void mark() {
        SavePoint savePoint = new SavePoint();
        savePoint.bp = this.pos;
        savePoint.sp = this.bufPos;
        savePoint.np = this.mark;
        savePoint.ch = this.ch;
        savePoint.token = this.token;
        this.savePoint = savePoint;
    }

    public void reset() {
        this.pos = this.savePoint.bp;
        this.bufPos = this.savePoint.sp;
        this.mark = this.savePoint.np;
        this.ch = this.savePoint.ch;
        this.token = this.savePoint.token;
    }

    public Lexer(String input, boolean skipComment) {
        this.skipComment = skipComment;
        this.text = input;
        this.pos = -1;
        this.scanChar();
    }

    public Lexer(char[] input, int inputLength, boolean skipComment) {
        this(new String(input, 0, inputLength), skipComment);
    }

    protected final void scanChar() {
        this.ch = this.charAt(++this.pos);
    }

    protected void unscan() {
        this.ch = this.charAt(--this.pos);
    }

    public boolean isEOF() {
        return this.pos >= this.text.length();
    }

    protected void lexError(String key, Object ... args) {
        this.token = Token.ERROR;
    }

    public final Token token() {
        return this.token;
    }

    public String info() {
        return (Object)((Object)this.token) + " " + this.stringVal();
    }

    public final void nextToken() {
        this.bufPos = 0;
        block23: while (true) {
            if (CharTypes.isWhitespace(this.ch)) {
                this.scanChar();
                continue;
            }
            if (this.ch == '$' && this.charAt(this.pos + 1) == '{') {
                this.scanVariable();
                return;
            }
            if (CharTypes.isFirstIdentifierChar(this.ch)) {
                if (this.ch == 'N' && this.charAt(this.pos + 1) == '\'') {
                    ++this.pos;
                    this.ch = (char)39;
                    this.scanString();
                    this.token = Token.LITERAL_NCHARS;
                    return;
                }
                this.scanIdentifier();
                return;
            }
            switch (this.ch) {
                case '0': {
                    if (this.charAt(this.pos + 1) == 'x') {
                        this.scanChar();
                        this.scanChar();
                        this.scanHexaDecimal();
                    } else {
                        this.scanNumber();
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber();
                    return;
                }
                case ',': {
                    this.scanChar();
                    this.token = Token.COMMA;
                    return;
                }
                case '(': {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                case ')': {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                case '[': {
                    this.scanChar();
                    this.token = Token.LBRACKET;
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.token = Token.RBRACKET;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.token = Token.LBRACE;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.token = Token.RBRACE;
                    return;
                }
                case ':': {
                    this.scanChar();
                    if (this.ch == '=') {
                        this.scanChar();
                        this.token = Token.COLONEQ;
                    } else if (this.isDigit(this.ch)) {
                        this.unscan();
                        this.scanVariable();
                    } else {
                        this.unscan();
                        this.scanVariable();
                    }
                    return;
                }
                case '#': {
                    this.scanVariable();
                    return;
                }
                case '.': {
                    this.scanChar();
                    if (this.isDigit(this.ch)) {
                        this.unscan();
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '.') {
                        this.scanChar();
                        if (this.ch == '.') {
                            this.scanChar();
                            this.token = Token.DOTDOTDOT;
                        } else {
                            this.token = Token.DOTDOT;
                        }
                    } else {
                        this.token = Token.DOT;
                    }
                    return;
                }
                case '\'': {
                    this.scanString();
                    return;
                }
                case '\"': {
                    this.scanAlias();
                    return;
                }
                case '*': {
                    this.scanChar();
                    this.token = Token.STAR;
                    return;
                }
                case '?': {
                    this.scanChar();
                    this.token = Token.QUES;
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.token = Token.SEMI;
                    return;
                }
                case '`': {
                    throw new SQLParseException("TODO");
                }
                case '@': {
                    this.scanVariable();
                    return;
                }
                case '-': {
                    char subNextChar = this.charAt(this.pos + 1);
                    if (subNextChar == '-') {
                        this.scanComment();
                        if ((this.token() == Token.LINE_COMMENT || this.token() == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block23;
                        }
                    } else {
                        this.scanOperator();
                    }
                    return;
                }
                case '/': {
                    char nextChar = this.charAt(this.pos + 1);
                    if (nextChar == '/' || nextChar == '*') {
                        this.scanComment();
                        if ((this.token() == Token.LINE_COMMENT || this.token() == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            this.bufPos = 0;
                            continue block23;
                        }
                    } else {
                        this.token = Token.SLASH;
                        this.scanChar();
                    }
                    return;
                }
            }
            break;
        }
        if (Character.isLetter(this.ch)) {
            this.scanIdentifier();
            return;
        }
        if (this.isOperator(this.ch)) {
            this.scanOperator();
            return;
        }
        if (this.isEOF()) {
            this.token = Token.EOF;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    private final void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                this.token = Token.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                this.token = Token.SUB;
                break;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                break;
            }
            case '/': {
                this.scanChar();
                this.token = Token.SLASH;
                break;
            }
            case '&': {
                this.scanChar();
                if (this.ch == '&') {
                    this.scanChar();
                    this.token = Token.AMPAMP;
                    break;
                }
                this.token = Token.AMP;
                break;
            }
            case '|': {
                this.scanChar();
                if (this.ch == '|') {
                    this.scanChar();
                    this.token = Token.BARBAR;
                    break;
                }
                this.token = Token.BAR;
                break;
            }
            case '^': {
                this.scanChar();
                this.token = Token.CARET;
                break;
            }
            case '%': {
                this.scanChar();
                this.token = Token.PERCENT;
                break;
            }
            case '=': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.EQEQ;
                    break;
                }
                this.token = Token.EQ;
                break;
            }
            case '>': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.GTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.GTGT;
                    break;
                }
                this.token = Token.GT;
                break;
            }
            case '<': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.token = Token.LTEQGT;
                        this.scanChar();
                        break;
                    }
                    this.token = Token.LTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.LTGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.LTLT;
                    break;
                }
                this.token = Token.LT;
                break;
            }
            case '!': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.BANGEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.BANGGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.BANGLT;
                    break;
                }
                this.token = Token.BANG;
                break;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                break;
            }
            case '~': {
                this.scanChar();
                this.token = Token.TILDE;
                break;
            }
            default: {
                throw new SQLParseException("TODO");
            }
        }
    }

    protected void scanString() {
        this.mark = this.pos;
        boolean hasSpecial = false;
        while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    private final void scanAlias() {
        this.mark = this.pos;
        if (this.buf == null) {
            this.buf = new char[32];
        }
        while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\"') break;
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.scanChar();
        this.token = Token.LITERAL_ALIAS;
        this.stringVal = this.subString(this.mark + 1, this.bufPos);
    }

    public void scanVariable() {
        char ch;
        if (this.ch != '@' && this.ch != ':' && this.ch != '#' && this.ch != '$') {
            throw new SQLParseException("illegal variable");
        }
        this.mark = this.pos;
        this.bufPos = 1;
        boolean mybatisFlag = false;
        if (this.charAt(this.pos + 1) == '@') {
            ch = this.charAt(++this.pos);
            ++this.bufPos;
        } else if (this.charAt(this.pos + 1) == '{') {
            ++this.pos;
            ++this.bufPos;
            mybatisFlag = true;
        }
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        if (mybatisFlag) {
            if (ch != '}') {
                throw new SQLParseException("syntax error");
            }
            ++this.pos;
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        this.token = Token.VARIANT;
    }

    public void scanComment() {
        if (!this.allowComment) {
            throw new NotAllowCommentException();
        }
        if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                    this.bufPos += 2;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.scanChar();
            this.scanChar();
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.MULTI_LINE_COMMENT;
            return;
        }
        if (this.ch == '/') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark + 1, this.bufPos);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    public void scanIdentifier() {
        char ch;
        char first = this.ch;
        boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
        if (!firstFlag) {
            throw new SQLParseException("illegal identifier");
        }
        this.mark = this.pos;
        this.bufPos = 1;
        while (CharTypes.isIdentifierChar(ch = this.charAt(++this.pos))) {
            ++this.bufPos;
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.addSymbol();
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    public void scanNumber() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            isDouble = true;
        }
        this.token = isDouble ? Token.LITERAL_FLOAT : Token.LITERAL_INT;
    }

    public void scanHexaDecimal() {
        this.mark = this.pos++;
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(this.pos);
        }
        while (CharTypes.isHex(this.ch)) {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        this.token = Token.LITERAL_HEX;
    }

    public String hexString() {
        return this.subString(this.mark, this.bufPos);
    }

    public final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected final void putChar(char ch) {
        if (this.bufPos == this.buf.length) {
            char[] newsbuf = new char[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newsbuf, 0, this.buf.length);
            this.buf = newsbuf;
        }
        this.buf[this.bufPos++] = ch;
    }

    public final int pos() {
        return this.pos;
    }

    public final String stringVal() {
        return this.stringVal;
    }

    private boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public Number integerValue() {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.mark;
        int max = this.mark + this.bufPos;
        if (this.charAt(this.mark) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.mark + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public int bp() {
        return this.pos;
    }

    public char current() {
        return this.ch;
    }

    public void reset(int mark, char markChar, Token token) {
        this.pos = mark;
        this.ch = markChar;
        this.token = token;
    }

    public final String numberString() {
        return this.subString(this.mark, this.bufPos);
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.text.toCharArray(), this.mark, this.bufPos);
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            Lexer.digits[i] = i - 48;
        }
    }

    private static class SavePoint {
        int bp;
        int sp;
        int np;
        char ch;
        Token token;

        private SavePoint() {
        }
    }
}

