/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy;

import com.alibaba.druid.VERSION;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterManager;
import com.alibaba.druid.proxy.DruidDriverMBean;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyConfig;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyImpl;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JMXUtils;
import com.alibaba.druid.util.JdbcUtils;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DruidDriver
implements Driver,
DruidDriverMBean {
    private static final Log LOG = LogFactory.getLog(DruidDriver.class);
    private static final DruidDriver instance = new DruidDriver();
    private static final ConcurrentMap<String, DataSourceProxyImpl> proxyDataSources = new ConcurrentHashMap<String, DataSourceProxyImpl>();
    private static final AtomicInteger dataSourceIdSeed = new AtomicInteger(0);
    private static final AtomicInteger sqlStatIdSeed = new AtomicInteger(0);
    public static final String DEFAULT_PREFIX = "jdbc:wrap-jdbc:";
    public static final String DRIVER_PREFIX = "driver=";
    public static final String PASSWORD_CALLBACK_PREFIX = "passwordCallback=";
    public static final String NAME_PREFIX = "name=";
    public static final String JMX_PREFIX = "jmx=";
    public static final String FILTERS_PREFIX = "filters=";
    private final AtomicLong connectCount = new AtomicLong(0L);
    private String acceptPrefix = "jdbc:wrap-jdbc:";
    private int majorVersion = 4;
    private int minorVersion = 0;
    private static final String MBEAN_NAME = "com.alibaba.druid:type=DruidDriver";

    public static boolean registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName objectName = new ObjectName(MBEAN_NAME);
                if (!mbeanServer.isRegistered(objectName)) {
                    mbeanServer.registerMBean(instance, objectName);
                }
            }
            catch (Exception ex) {
                LOG.error("register druid-driver mbean error", ex);
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("registerDriver error", e);
            return false;
        }
    }

    public static DruidDriver getInstance() {
        return instance;
    }

    public static int createDataSourceId() {
        return dataSourceIdSeed.incrementAndGet();
    }

    public static int createSqlStatId() {
        return sqlStatIdSeed.incrementAndGet();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(this.acceptPrefix);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        this.connectCount.incrementAndGet();
        DataSourceProxyImpl dataSource = this.getDataSource(url, info);
        return dataSource.connect(info);
    }

    private DataSourceProxyImpl getDataSource(String url, Properties info) throws SQLException {
        DataSourceProxyImpl dataSource = (DataSourceProxyImpl)proxyDataSources.get(url);
        if (dataSource == null) {
            DataSourceProxyConfig config = DruidDriver.parseConfig(url, info);
            Driver rawDriver = this.createDriver(config.getRawDriverClassName());
            DataSourceProxyImpl newDataSource = new DataSourceProxyImpl(rawDriver, config);
            String property = System.getProperty("druid.filters");
            if (property != null && property.length() > 0) {
                for (String filterItem : property.split(",")) {
                    FilterManager.loadFilter(config.getFilters(), filterItem);
                }
            }
            int dataSourceId = DruidDriver.createDataSourceId();
            newDataSource.setId(dataSourceId);
            for (Filter filter : config.getFilters()) {
                filter.init(newDataSource);
            }
            DataSourceProxy oldDataSource = proxyDataSources.putIfAbsent(url, newDataSource);
            if (oldDataSource == null && config.isJmxOption()) {
                JMXUtils.register("com.alibaba.druid:type=JdbcStat", JdbcStatManager.getInstance());
            }
            dataSource = (DataSourceProxyImpl)proxyDataSources.get(url);
        }
        return dataSource;
    }

    public static DataSourceProxyConfig parseConfig(String url, Properties info) throws SQLException {
        int pos;
        String restUrl = url.substring(DEFAULT_PREFIX.length());
        DataSourceProxyConfig config = new DataSourceProxyConfig();
        if (restUrl.startsWith(DRIVER_PREFIX)) {
            pos = restUrl.indexOf(58, DRIVER_PREFIX.length());
            String driverText = restUrl.substring(DRIVER_PREFIX.length(), pos);
            if (driverText.length() > 0) {
                config.setRawDriverClassName(driverText.trim());
            }
            restUrl = restUrl.substring(pos + 1);
        }
        if (restUrl.startsWith(FILTERS_PREFIX)) {
            pos = restUrl.indexOf(58, FILTERS_PREFIX.length());
            String filtersText = restUrl.substring(FILTERS_PREFIX.length(), pos);
            for (String filterItem : filtersText.split(",")) {
                FilterManager.loadFilter(config.getFilters(), filterItem);
            }
            restUrl = restUrl.substring(pos + 1);
        }
        if (restUrl.startsWith(NAME_PREFIX)) {
            pos = restUrl.indexOf(58, NAME_PREFIX.length());
            String name = restUrl.substring(NAME_PREFIX.length(), pos);
            config.setName(name);
            restUrl = restUrl.substring(pos + 1);
        }
        if (restUrl.startsWith(JMX_PREFIX)) {
            pos = restUrl.indexOf(58, JMX_PREFIX.length());
            String jmxOption = restUrl.substring(JMX_PREFIX.length(), pos);
            config.setJmxOption(jmxOption);
            restUrl = restUrl.substring(pos + 1);
        }
        String rawUrl = restUrl;
        config.setRawUrl(rawUrl);
        if (config.getRawDriverClassName() == null) {
            String rawDriverClassname = JdbcUtils.getDriverClassName(rawUrl);
            config.setRawDriverClassName(rawDriverClassname);
        }
        config.setUrl(url);
        return config;
    }

    public Driver createDriver(String className) throws SQLException {
        Driver rawDriver;
        Class<?> rawDriverClass = JdbcUtils.loadDriverClass(className);
        if (rawDriverClass == null) {
            throw new SQLException("jdbc-driver's class not found. '" + className + "'");
        }
        try {
            rawDriver = (Driver)rawDriverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("create driver instance error, driver className '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException("create driver instance error, driver className '" + className + "'", e);
        }
        return rawDriver;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DataSourceProxyImpl dataSource = this.getDataSource(url, info);
        return dataSource.getRawDriver().getPropertyInfo(dataSource.getConfig().getRawUrl(), info);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public long getConnectCount() {
        return this.connectCount.get();
    }

    @Override
    public String getAcceptPrefix() {
        return this.acceptPrefix;
    }

    @Override
    public String[] getDataSourceUrls() {
        return proxyDataSources.keySet().toArray(new String[proxyDataSources.size()]);
    }

    public static ConcurrentMap<String, DataSourceProxyImpl> getProxyDataSources() {
        return proxyDataSources;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void resetStat() {
        this.connectCount.set(0L);
    }

    @Override
    public String getDruidVersion() {
        return VERSION.getVersionNumber();
    }

    static {
        DruidDriver.registerDriver(instance);
    }
}

