/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLDDLParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLCreateTableParser
extends SQLDDLParser {
    public SQLCreateTableParser(String sql) {
        super(sql);
    }

    public SQLCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public SQLCreateTableStatement parseCrateTable() {
        return this.parseCrateTable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLCreateTableStatement parseCrateTable(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateTableStatement createTable = this.newCreateStatement();
        if (this.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error");
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() != Token.LPAREN) return createTable;
        this.lexer.nextToken();
        while (true) {
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS) {
                SQLColumnDefinition column = this.exprParser.parseColumn();
                createTable.getTableElementList().add(column);
            } else if (this.lexer.token() == Token.PRIMARY) {
                SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                createTable.getTableElementList().add(primaryKey);
            } else {
                if (this.lexer.token != Token.UNIQUE) throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
                SQLUnique unique = this.exprParser.parseUnique();
                createTable.getTableElementList().add(unique);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return createTable;
    }

    protected SQLCreateTableStatement newCreateStatement() {
        return new SQLCreateTableStatement();
    }
}

