/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;

public class MySqlParameterizedOutputVisitor
extends MySqlOutputVisitor {
    public MySqlParameterizedOutputVisitor() {
        this(new StringBuilder());
    }

    public MySqlParameterizedOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        return ParameterizedOutputVisitorUtils.visit(this, x);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        if (x.getParent() instanceof SQLExprTableSource || x.getParent() instanceof SQLPropertyExpr) {
            char ch;
            int i;
            int pos = name.lastIndexOf(95);
            if (pos != -1 && pos != name.length()) {
                boolean isNumber = true;
                for (i = pos + 1; i < name.length(); ++i) {
                    ch = name.charAt(i);
                    if (ch >= '0' && ch <= '9') continue;
                    isNumber = false;
                    break;
                }
                if (isNumber) {
                    String realName = name.substring(0, pos);
                    this.print(realName);
                    return false;
                }
            }
            int numberCount = 0;
            for (i = name.length() - 1; i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9'; --i) {
                ++numberCount;
            }
            if (numberCount > 1) {
                int numPos = name.length() - numberCount;
                String realName = name.substring(0, numPos);
                this.print(realName);
                return false;
            }
        }
        this.print(name);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x = ParameterizedOutputVisitorUtils.merge(x);
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute("druid.parameterized.skip"))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute("druid.parameterized.skip"))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute("druid.parameterized.skip"))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute("druid.parameterized.skip"))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        this.print("INSERT ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        if (x.isHighPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        this.print("INTO ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
        }
        if (x.getValuesList().size() != 0) {
            this.print(" VALUES ");
            int size = x.getValuesList().size();
            if (size == 0) {
                this.print("()");
            } else {
                for (int i = 0; i < 1; ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    x.getValuesList().get(i).accept(this);
                }
            }
        }
        if (x.getQuery() != null) {
            this.print(" ");
            x.getQuery().accept(this);
        }
        if (x.getDuplicateKeyUpdate().size() != 0) {
            this.print(" ON DUPLICATE KEY UPDATE ");
            this.printAndAccept(x.getDuplicateKeyUpdate(), ", ");
        }
        return false;
    }
}

