/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlForceIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIgnoreIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIndexHintImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUseIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectGroupBy;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlSelectParser
extends SQLSelectParser {
    public MySqlSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public MySqlSelectParser(String sql) {
        this(new MySqlExprParser(sql));
    }

    @Override
    public SQLSelectQuery query() {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.HINT) {
                this.exprParser.parseHints(queryBlock.getHints());
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.identifierEquals("DISTINCTROW")) {
                queryBlock.setDistionOption(4);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("HIGH_PRIORITY")) {
                queryBlock.setHignPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("STRAIGHT_JOIN")) {
                queryBlock.setStraightJoin(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_SMALL_RESULT")) {
                queryBlock.setSmallResult(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_BIG_RESULT")) {
                queryBlock.setBigResult(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_BUFFER_RESULT")) {
                queryBlock.setBufferResult(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_CACHE")) {
                queryBlock.setCache(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_NO_CACHE")) {
                queryBlock.setCache(false);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SQL_CALC_FOUND_ROWS")) {
                queryBlock.setCalcFoundRows(true);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.identifierEquals("OUTFILE")) {
                    this.lexer.nextToken();
                    MySqlOutFileExpr outFile = new MySqlOutFileExpr();
                    outFile.setFile(this.expr());
                    queryBlock.setInto(outFile);
                    if (this.identifierEquals("FIELDS") || this.identifierEquals("COLUMNS")) {
                        this.lexer.nextToken();
                        if (this.identifierEquals("TERMINATED")) {
                            this.lexer.nextToken();
                            this.accept(Token.BY);
                        }
                        outFile.setColumnsTerminatedBy((SQLLiteralExpr)this.expr());
                        if (this.identifierEquals("OPTIONALLY")) {
                            this.lexer.nextToken();
                            outFile.setColumnsEnclosedOptionally(true);
                        }
                        if (this.identifierEquals("ENCLOSED")) {
                            this.lexer.nextToken();
                            this.accept(Token.BY);
                            outFile.setColumnsEnclosedBy((SQLLiteralExpr)this.expr());
                        }
                        if (this.identifierEquals("ESCAPED")) {
                            this.lexer.nextToken();
                            this.accept(Token.BY);
                            outFile.setColumnsEscaped((SQLLiteralExpr)this.expr());
                        }
                    }
                    if (this.identifierEquals("LINES")) {
                        this.lexer.nextToken();
                        if (this.identifierEquals("STARTING")) {
                            this.lexer.nextToken();
                            this.accept(Token.BY);
                            outFile.setLinesStartingBy((SQLLiteralExpr)this.expr());
                        } else {
                            this.identifierEquals("TERMINATED");
                            this.lexer.nextToken();
                            this.accept(Token.BY);
                            outFile.setLinesTerminatedBy((SQLLiteralExpr)this.expr());
                        }
                    }
                } else {
                    queryBlock.setInto(this.exprParser.name());
                }
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        if (this.lexer.token() == Token.LIMIT) {
            queryBlock.setLimit(this.parseLimit());
        }
        if (this.identifierEquals("PROCEDURE")) {
            this.lexer.nextToken();
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLName expr = this.exprParser.name();
            queryBlock.setInto(expr);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            queryBlock.setForUpdate(true);
        }
        if (this.lexer.token() == Token.LOCK) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.acceptIdentifier("SHARE");
            this.acceptIdentifier("MODE");
            queryBlock.setLockInShareMode(true);
        }
        return this.queryRest(queryBlock);
    }

    @Override
    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            while (true) {
                groupBy.getItems().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.identifierEquals("WITH")) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                MySqlSelectGroupBy mySqlGroupBy = new MySqlSelectGroupBy();
                mySqlGroupBy.getItems().addAll(groupBy.getItems());
                mySqlGroupBy.setRollUp(true);
                groupBy = mySqlGroupBy;
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                groupBy.setHaving(this.exprParser.expr());
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        MySqlIndexHintImpl hint;
        if (this.identifierEquals("USING")) {
            return tableSource;
        }
        if (this.lexer.token() == Token.USE) {
            this.lexer.nextToken();
            hint = new MySqlUseIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        if (this.identifierEquals("IGNORE")) {
            this.lexer.nextToken();
            hint = new MySqlIgnoreIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        if (this.identifierEquals("FORCE")) {
            this.lexer.nextToken();
            hint = new MySqlForceIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        return super.parseTableSourceRest(tableSource);
    }

    private void parseIndexHint(MySqlIndexHintImpl hint) {
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.KEY);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.JOIN) {
                this.lexer.nextToken();
                hint.setOption(MySqlIndexHint.Option.JOIN);
            } else if (this.lexer.token() == Token.ORDER) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                hint.setOption(MySqlIndexHint.Option.ORDER_BY);
            } else {
                this.accept(Token.GROUP);
                this.accept(Token.BY);
                hint.setOption(MySqlIndexHint.Option.GROUP_BY);
            }
        }
        this.accept(Token.LPAREN);
        if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            hint.getIndexList().add(new SQLIdentifierExpr("PRIMARY"));
        } else {
            this.exprParser.names(hint.getIndexList());
        }
        this.accept(Token.RPAREN);
    }

    @Override
    protected MySqlUnionQuery createSQLUnionQuery() {
        return new MySqlUnionQuery();
    }

    @Override
    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token() == Token.LIMIT) {
            MySqlUnionQuery mysqlUnionQuery = (MySqlUnionQuery)union;
            mysqlUnionQuery.setLimit(this.parseLimit());
        }
        return super.unionRest(union);
    }

    public MySqlSelectQueryBlock.Limit parseLimit() {
        return ((MySqlExprParser)this.exprParser).parseLimit();
    }
}

