/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ParamFlowRuleUtil {
    public static boolean isValidRule(ParamFlowRule rule) {
        return rule != null && !StringUtil.isBlank((String)rule.getResource()) && rule.getCount() >= 0.0 && rule.getGrade() >= 0 && rule.getParamIdx() != null && rule.getBurstCount() >= 0 && rule.getControlBehavior() >= 0 && rule.getDurationInSec() > 0L && rule.getMaxQueueingTimeMs() >= 0 && ParamFlowRuleUtil.checkCluster(rule);
    }

    private static boolean checkCluster(ParamFlowRule rule) {
        if (!rule.isClusterMode()) {
            return true;
        }
        ParamFlowClusterConfig clusterConfig = rule.getClusterConfig();
        if (clusterConfig == null) {
            return false;
        }
        if (!FlowRuleUtil.isWindowConfigValid((int)clusterConfig.getSampleCount(), (int)clusterConfig.getWindowIntervalMs())) {
            return false;
        }
        return ParamFlowRuleUtil.validClusterRuleId(clusterConfig.getFlowId());
    }

    public static boolean validClusterRuleId(Long id) {
        return id != null && id > 0L;
    }

    public static void fillExceptionFlowItems(ParamFlowRule rule) {
        if (rule != null) {
            if (rule.getParamFlowItemList() == null) {
                rule.setParamFlowItemList(new ArrayList<ParamFlowItem>());
            }
            Map<Object, Integer> itemMap = ParamFlowRuleUtil.parseHotItems(rule.getParamFlowItemList());
            rule.setParsedHotItems(itemMap);
        }
    }

    static Map<Object, Integer> parseHotItems(List<ParamFlowItem> items) {
        HashMap<Object, Integer> itemMap = new HashMap<Object, Integer>();
        if (items == null || items.isEmpty()) {
            return itemMap;
        }
        for (ParamFlowItem item : items) {
            Object value;
            try {
                value = ParamFlowRuleUtil.parseItemValue(item.getObject(), item.getClassType());
            }
            catch (Exception ex) {
                RecordLog.warn((String)("[ParamFlowRuleUtil] Failed to parse value for item: " + item), (Throwable)ex);
                continue;
            }
            if (item.getCount() == null || item.getCount() < 0 || value == null) {
                RecordLog.warn((String)("[ParamFlowRuleUtil] Ignoring invalid exclusion parameter item: " + item), (Object[])new Object[0]);
                continue;
            }
            itemMap.put(value, item.getCount());
        }
        return itemMap;
    }

    static Object parseItemValue(String value, String classType) {
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        if (StringUtil.isBlank((String)classType)) {
            return value;
        }
        if (Integer.TYPE.toString().equals(classType) || Integer.class.getName().equals(classType)) {
            return Integer.parseInt(value);
        }
        if (Boolean.TYPE.toString().equals(classType) || Boolean.class.getName().equals(classType)) {
            return Boolean.parseBoolean(value);
        }
        if (Long.TYPE.toString().equals(classType) || Long.class.getName().equals(classType)) {
            return Long.parseLong(value);
        }
        if (Double.TYPE.toString().equals(classType) || Double.class.getName().equals(classType)) {
            return Double.parseDouble(value);
        }
        if (Float.TYPE.toString().equals(classType) || Float.class.getName().equals(classType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Byte.TYPE.toString().equals(classType) || Byte.class.getName().equals(classType)) {
            return Byte.parseByte(value);
        }
        if (Short.TYPE.toString().equals(classType) || Short.class.getName().equals(classType)) {
            return Short.parseShort(value);
        }
        if (Character.TYPE.toString().equals(classType)) {
            char[] array = value.toCharArray();
            return array.length > 0 ? Character.valueOf(array[0]) : null;
        }
        return value;
    }

    private ParamFlowRuleUtil() {
    }
}

