/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.Location;
import flash.tools.debugger.expression.ValueExp;
import flex.tools.debugger.cli.BreakIdentifier;
import flex.tools.debugger.cli.LocationCollection;
import java.util.Iterator;
import java.util.Vector;

public class BreakAction {
    public static final int RESOLVED = 1;
    public static final int UNRESOLVED = 2;
    public static final int AMBIGUOUS = 3;
    public static final int NOCODE = 4;
    private LocationCollection m_where;
    private String m_breakpointExpression;
    private Vector<String> m_commands;
    private boolean m_enabled;
    private boolean m_autoDelete;
    private boolean m_autoDisable;
    private boolean m_silent;
    private boolean m_singleSwf;
    private int m_id;
    private int m_hits;
    private ValueExp m_condition;
    private String m_conditionString;
    private int m_status;

    public BreakAction(LocationCollection c) throws NullPointerException {
        this.m_where = c;
        this.m_where.first().getFile();
        this.m_status = 1;
        this.init();
    }

    public BreakAction(String unresolvedLocation) {
        this.m_breakpointExpression = unresolvedLocation;
        this.m_status = 2;
        this.init();
    }

    private void init() {
        this.m_id = BreakIdentifier.next();
        this.m_commands = new Vector();
    }

    public int getCommandCount() {
        return this.m_commands.size();
    }

    public String commandAt(int i) {
        return this.m_commands.elementAt(i);
    }

    public Location getLocation() {
        return this.m_where != null ? this.m_where.first() : null;
    }

    public LocationCollection getLocations() {
        return this.m_where;
    }

    public int getId() {
        return this.m_id;
    }

    public int getHits() {
        return this.m_hits;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isAutoDisable() {
        return this.m_autoDisable;
    }

    public boolean isAutoDelete() {
        return this.m_autoDelete;
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public boolean isSingleSwf() {
        return this.m_singleSwf;
    }

    public ValueExp getCondition() {
        return this.m_condition;
    }

    public String getConditionString() {
        return this.m_conditionString;
    }

    public String getBreakpointExpression() {
        return this.m_breakpointExpression;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void addCommand(String cmd) {
        this.m_commands.add(cmd);
    }

    public void clearCommands() {
        this.m_commands.clear();
    }

    public void addLocation(Location l) {
        this.m_where.add(l);
    }

    public void setEnabled(boolean enable) {
        this.m_enabled = enable;
    }

    public void setAutoDisable(boolean disable) {
        this.m_autoDisable = disable;
    }

    public void setAutoDelete(boolean delete) {
        this.m_autoDelete = delete;
    }

    public void setSilent(boolean silent) {
        this.m_silent = silent;
    }

    public void setCondition(ValueExp c, String s) {
        this.m_condition = c;
        this.m_conditionString = s;
    }

    public void clearCondition() {
        this.setCondition(null, "");
    }

    public void hit() {
        ++this.m_hits;
    }

    public void clearHits() {
        this.m_hits = 0;
    }

    public void setSingleSwf(boolean singleSwf) {
        this.m_singleSwf = singleSwf;
    }

    public void setBreakpointExpression(String expr) {
        this.m_breakpointExpression = expr;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    public void setLocations(LocationCollection loc) {
        this.m_where = loc;
        if (loc != null) {
            this.setStatus(1);
        }
    }

    public boolean locationMatches(int fileId, int line) {
        boolean match = false;
        LocationCollection col = this.getLocations();
        if (col != null) {
            Iterator<Location> itr = col.iterator();
            while (!match && itr.hasNext()) {
                Location l = itr.next();
                if (l == null || l.getFile().getId() != fileId || l.getLine() != line) continue;
                match = true;
            }
        }
        return match;
    }
}

