/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class LOOKUPSWITCH
extends Select {
    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super((short)171, match, targets, defaultTarget);
        this.length = (short)(9 + this.match_length * 8);
        this.fixed_length = this.length;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeInt(this.match_length);
        for (int i2 = 0; i2 < this.match_length; ++i2) {
            out.writeInt(this.match[i2]);
            this.indices[i2] = this.getTargetOffset(this.targets[i2]);
            out.writeInt(this.indices[i2]);
        }
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.match_length = bytes.readInt();
        this.fixed_length = (short)(9 + this.match_length * 8);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        for (int i2 = 0; i2 < this.match_length; ++i2) {
            this.match[i2] = bytes.readInt();
            this.indices[i2] = bytes.readInt();
        }
    }

    public void accept(Visitor v2) {
        v2.visitVariableLengthInstruction(this);
        v2.visitStackProducer(this);
        v2.visitBranchInstruction(this);
        v2.visitSelect(this);
        v2.visitLOOKUPSWITCH(this);
    }
}

