/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;

public class LCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private long value;

    LCONST() {
    }

    public LCONST(long l2) {
        super((short)9, (short)1);
        if (l2 == 0L) {
            this.opcode = (short)9;
        } else if (l2 == 1L) {
            this.opcode = (short)10;
        } else {
            throw new ClassGenException("LCONST can be used only for 0 and 1: " + l2);
        }
        this.value = l2;
    }

    public Number getValue() {
        return new Long(this.value);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.LONG;
    }

    public void accept(Visitor v2) {
        v2.visitPushInstruction(this);
        v2.visitStackProducer(this);
        v2.visitTypedInstruction(this);
        v2.visitConstantPushInstruction(this);
        v2.visitLCONST(this);
    }
}

